package jp.agentec.abook.abv.ui.home.activity;

import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.view.View;
import android.view.Window;
import android.webkit.CookieManager;
import android.webkit.DownloadListener;
import android.webkit.JavascriptInterface;
import android.webkit.JsResult;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Toast;


import org.json.JSONArray;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import jp.agentec.abook.abv.bl.acms.client.AcmsClient;
import jp.agentec.abook.abv.bl.acms.client.json.AcmsCommonJSON;
import jp.agentec.abook.abv.bl.acms.client.json.RoomListJSON;
import jp.agentec.abook.abv.bl.acms.client.parameters.AcmsParameters;
import jp.agentec.abook.abv.bl.acms.type.AcmsApis;
import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.constant.ABookKeys;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.NetworkDisconnectedException;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.data.ABVDataCache;
import jp.agentec.abook.abv.bl.dto.ChatRoomDto;
import jp.agentec.abook.abv.bl.dto.ContentReadingLogDto;
import jp.agentec.abook.abv.bl.dto.PushMessageDto;
import jp.agentec.abook.abv.bl.logic.AbstractLogic;
import jp.agentec.abook.abv.bl.logic.CommunicationLogic;
import jp.agentec.abook.abv.bl.logic.ContentLogic;
import jp.agentec.abook.abv.cl.util.PreferenceUtil;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType;
import jp.agentec.abook.abv.ui.common.constant.ErrorCode;
import jp.agentec.abook.abv.ui.common.constant.ErrorMessage;
import jp.agentec.abook.abv.ui.common.constant.NaviConsts;
import jp.agentec.abook.abv.ui.common.dialog.ABookAlertDialog;
import jp.agentec.abook.abv.ui.common.util.ABVToastUtil;
import jp.agentec.abook.abv.ui.common.util.AlertDialogUtil;
import jp.agentec.abook.abv.ui.home.helper.ActivityHandlingHelper;
import jp.agentec.abook.abv.ui.viewer.activity.ParentWebViewActivity;
import jp.agentec.adf.net.http.HttpResponse;

import static org.chromium.net.NetError.ERR_FAILED;

/**
 * Created by AIS-NB-048 on 2019/07/31.
 */

public class ChatWebviewActivity extends ParentWebViewActivity {
    private WebView mChatWebView;
    private String chatWebviewUrl;

    private final String TAG = "ChatWebviewActivity";

    private final String NETWORK_ERROR_PLACE_HOLDER = "file:///android_asset/chat/public/index.html";
    //private final String NETWORK_ERROR_PLACE_HOLDER = "file:///android_asset/chat/public/networkError.html";
    private final String CHAT_PAGE_URL = "file:///android_asset/chat/public/index.html";

    //AISDevelop
    private JsInf jsInf = new JsInf();

    private ValueCallback<Uri[]> mUploadMessage;

    private String sid, roomName, loginId, shopName;
    private boolean isOnline;
    private Long roomId;

    public AlertDialog myAlertDialog;

    private ImageButton mOperationHomeButton;                // ホームボタン
    private ImageButton mOperationRelatedContentButton;      // 関連資料ボタン

    private BroadcastReceiver receiver;

    private CommunicationLogic communicationLogic = AbstractLogic.getLogic(CommunicationLogic.class);

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (isNormalSize()) {
            setPortraitIfNormal();
        }
        setContentView(R.layout.chat_webview);
        Intent intent = getIntent();

        sid = intent.getStringExtra("sid");
        roomId = intent.getLongExtra("roomId", 0);
        roomName = intent.getStringExtra("roomName");
        loginId = intent.getStringExtra("loginId");
        shopName = intent.getStringExtra("shopName");
        isOnline = false;

        //ネットワークがない場合専用のページを表示。
        chatWebviewUrl = NETWORK_ERROR_PLACE_HOLDER;
        if (ABVEnvironment.getInstance().networkAdapter.isNetworkConnected()) {
            try {
                if (AcmsClient.getInstance(ABVEnvironment.getInstance().networkAdapter).checkSid(sid)) {
                    isOnline = true;
                    chatWebviewUrl = CHAT_PAGE_URL;
                }
            } catch (Exception e) {
                Logger.d("SID_CHECK_ERROR");
            }
        } else {
            Logger.d("DEVICE_NOT_CONNECTED_NETWORK:");
        }

        mChatWebView = findViewById(R.id.chatWebview2);
        mChatWebView.setOverScrollMode(View.OVER_SCROLL_NEVER);  //オーバースクロールしない。
        mChatWebView.setVerticalScrollBarEnabled(false); //スクロールバーを消す。

        WebSettings settings = mChatWebView.getSettings();
        settings.setJavaScriptEnabled(true); //Javascriptを有効にする。
        settings.setAppCacheEnabled(false);
        settings.setCacheMode(WebSettings.LOAD_NO_CACHE);

        settings.setMixedContentMode(WebSettings.MIXED_CONTENT_ALWAYS_ALLOW);
        settings.setDomStorageEnabled(true);
        settings.setDatabaseEnabled(true);
        settings.setMediaPlaybackRequiresUserGesture(false);
        settings.setAllowFileAccess(true);
        settings.setUseWideViewPort(true);
        settings.setAllowContentAccess(true);
        settings.setAllowFileAccessFromFileURLs(true);
        settings.setAllowUniversalAccessFromFileURLs(true);
        if (Logger.isDebugEnabled()) {
            mChatWebView.setWebContentsDebuggingEnabled(true); //デバッグモード（chromeからinspect可)
        }

        // 最後のチャットのルーム名
        String lastRoomName = PreferenceUtil.getUserPref(getApplicationContext(), AppDefType.UserPrefKey.CHAT_LAST_ROOMNAME, "");
        // 最後のチャットのルーム
        String lastRoomId = PreferenceUtil.getUserPref(getApplicationContext(), AppDefType.UserPrefKey.CHAT_LAST_ROOMID, "");

        mChatWebView.addJavascriptInterface(jsInf, "android");

        String fixedParam = "&platform=android&isMobile=true&chatServerUrl=" + ABVEnvironment.getInstance().websocketServerHttpUrl;
        //ページをロード
        if(roomId != 0 && roomName != null) {  // by push message
            String parameterData = "sid=" + sid + "&loginId=" + loginId +  "&shopName=" + shopName +  "&roomId=" + roomId + "&roomName=" + roomName + fixedParam;
            mChatWebView.postUrl(chatWebviewUrl, parameterData.getBytes());
        }
        else {  // Chat
            if (lastRoomName.length() > 0 && lastRoomId.length() > 0) {
                String parameterData = "sid=" + sid + "&loginId=" + loginId +  "&shopName=" + shopName +  "&roomId=" + lastRoomId + "&roomName=" + lastRoomName + fixedParam;
                mChatWebView.postUrl(chatWebviewUrl, parameterData.getBytes());
            } else {
                String parameterData = "sid=" + sid + "&loginId=" + loginId + "&shopName=" + shopName + fixedParam;
                mChatWebView.postUrl(chatWebviewUrl, parameterData.getBytes());
            }
        }

        mChatWebView.setWebChromeClient(new WebChromeClient() {
            @Override
            public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, FileChooserParams fileChooserParams) {
                boolean result = false;
                // 画像が選択された場合
                if (fileChooserParams.getAcceptTypes()[0].toLowerCase().indexOf(ABookKeys.IMAGE) != -1) {
                    result = startCameraIntent(ABOOK_CHECK_TASK_IMAGE, "Camera", ABookKeys.IMAGE, true);
                    // 動画が選択された場合
                } else if (fileChooserParams.getAcceptTypes()[0].toLowerCase().indexOf(ABookKeys.VIDEO) != -1) {
                    result = startCameraIntent(ABOOK_CHECK_TASK_VIDEO, "Camera", ABookKeys.VIDEO, true);
                }
                if (result) {
                    if (mUploadMessage != null) {
                        mUploadMessage.onReceiveValue(null);
                    }
                    mUploadMessage = filePathCallback;
                }
                return result;
            }

            // WebView内のAlert Dialogを処理する
            @Override
            public boolean onJsAlert(WebView view, String url, String message, final JsResult result) {
                if (myAlertDialog != null && myAlertDialog.isShowing()) {
                    result.confirm();
                    return true;
                }

                if (message.equals("server error Ocurred")) {
                    message = getString(R.string.msg_error_chat_server);
                } else if (message.equals("Disconnected from the server")) {
                    message = getString(R.string.msg_error_chat_disconnected);
                } else if (message.equals("connect_error")) {
                    message = getString(R.string.msg_error_chat_connect);
                } else if (message.equals("Room not found")) {
                    message = getString(R.string.msg_error_chat_room_not_found);
                } else if (message.equals("ServerError 500")) {
                    message = getString(R.string.msg_error_chat_500);
                } else if (message.equals("error chat join")) {
                    message = getString(R.string.msg_error_chat_join);
                } else if (message.equals("Message length error")) {
                    message = getString(R.string.msg_error_chat_text_length);
                    // #36130 start
                } else if (message.equals("Input RoomName")) {
                    message = getString(R.string.msg_error_chat_input_roomname);
                    // #36130 end
                    // #36142
                } else if (message.equals("Please enter room name less than 20 characters")) {
                    message = getString(R.string.msg_error_chat_room_name_too_long);
                } else if (message.equals("InvalidSpecialCharacterRoomName")) {
                    message = getString(R.string.msg_error_chat_name_has_invalid_character);
                } else if (message.equals("SC_FORBIDDEN")) {
                    message = getString(R.string.msg_error_chat_room_sc_forbidden);
                } else {
                    message = message;
                }

                final String tempMessage = message;

                ABookAlertDialog dialog = AlertDialogUtil.createAlertDialog(ChatWebviewActivity.this, R.string.app_name);
                dialog.setMessage(message);
                dialog.setPositiveButton(R.string.ok, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                dialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
                    @Override
                    public void onDismiss(DialogInterface dialog) {
                        // サーバと接続された場合、チャット画面を閉じる

                        if (tempMessage.equals(getString(R.string.msg_error_chat_disconnected)) || tempMessage.equals(getString(R.string.msg_error_chat_room_sc_forbidden))) {
                            mChatWebView.loadUrl("javascript:CHAT.leaveRoom()");
                            finish();
                        } else if (tempMessage.equals(getString(R.string.msg_error_chat_join))) {
                            getLogin();
                            finish();
                        }
                    }
                });

                myAlertDialog = dialog;
                if (!isFinishing()) {
                    dialog.show();
                }
                result.confirm();
                return true;
            }

            // WebView内のConfirm Dialogを処理する
            @Override
            public boolean onJsConfirm(WebView view, String url, String message, final JsResult result) {
                if (message.equals("Do you want to leave this room?")) {
                    message = getString(R.string.msg_chat_confirm_exit);
                } else if (message.equals("Do you want to remove selected members from the list?")) {
                    message = getString(R.string.msg_chat_confirm_member);
                    // #36128
                } else if (message.equals("Do you want to delete this room?")) {
                    message = getString(R.string.msg_chat_confirm_delete);
                } else {
                    message = "Confirm ?";
                }
                ABookAlertDialog confirmAlert = AlertDialogUtil.createAlertDialog(ChatWebviewActivity.this, R.string.app_name);
                confirmAlert.setMessage(message);
                confirmAlert.setButton(DialogInterface.BUTTON_POSITIVE, getResources().getString(R.string.confirm), new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        result.confirm();
                    }
                });
                confirmAlert.setButton(DialogInterface.BUTTON_NEGATIVE, getResources().getString(R.string.cancel), new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        result.cancel();
                    }
                });
                confirmAlert.setCancelable(false);
                showAlertDialog(confirmAlert);

                return true;
            }
        });

        mChatWebView.setDownloadListener(new DownloadListener() {
            @Override
            public void onDownloadStart(String url, String userAgent,
                                        String contentDisposition, String mimetype,
                                        long contentLength) {
                Uri uri = Uri.parse(url);
                DownloadManager.Request request = new DownloadManager.Request(uri);

                final String fileName = uri.getQueryParameter("fileName");

                //------------------------COOKIE!!------------------------
                String cookies = CookieManager.getInstance().getCookie(url);
                request.addRequestHeader("cookie", cookies);
                //------------------------COOKIE!!------------------------
                request.addRequestHeader("User-Agent", userAgent);
                request.setTitle(fileName);
                request.allowScanningByMediaScanner();
                request.setNotificationVisibility(DownloadManager.Request.VISIBILITY_VISIBLE_NOTIFY_COMPLETED); //Notify client once download is completed!
                request.setDestinationInExternalPublicDir(Environment.DIRECTORY_DOWNLOADS, fileName);
                DownloadManager dm = (DownloadManager) getSystemService(DOWNLOAD_SERVICE);
                if (dm != null) {
                    dm.enqueue(request);
                }
                Toast.makeText(getApplicationContext(), getString(R.string.download_start), //To notify the Client that the file is being downloaded
                        Toast.LENGTH_LONG).show();
            }
        });

        // ブロードキャストレシーバーの追加
        receiver = new BroadcastReceiver() {
            @Override
            public void onReceive(Context context, Intent intent) {
                if (DownloadManager.ACTION_DOWNLOAD_COMPLETE.equals(intent.getAction())) {
                    mChatWebView.loadUrl("javascript:CHAT_UI.dismissLoadingIndicator()");
                }
            }
        };

        // レシーバーオブジェクトの生成
        IntentFilter tempIntent = new IntentFilter(DownloadManager.ACTION_DOWNLOAD_COMPLETE);
        registerReceiver(receiver, tempIntent);

        mChatWebView.setWebViewClient(new WebViewClient() {
            @Override
            public void onReceivedError(WebView view, int errorCode,
                                        String description, String failingUrl) {

                if (errorCode == ERR_FAILED) {

                    mChatWebView.removeView(view);
                    view.removeAllViews();
                    mChatWebView.reload();
                    mChatWebView.loadUrl(NETWORK_ERROR_PLACE_HOLDER);
                }
                Logger.d("WEB_VIEW_ERROR", "error code:" + errorCode + " - " + description);
            }

            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                Logger.d("url", "url : " + url);

                Uri uri = Uri.parse(url);
                String fileName = new File(Objects.requireNonNull(uri.getPath())).getName();

                // イメージをダウンロードする(png, jpg, jpeg, mp4, mov)
                if (url.toLowerCase().endsWith(".png") || url.toLowerCase().endsWith(".jpg") || url.toLowerCase().endsWith(".jpeg")
                        || url.toLowerCase().endsWith(".mov") || url.toLowerCase().endsWith(".mp4")) {
                    view.loadUrl("javascript:CHAT_UI.showLoadingIndicator()");
                    DownloadManager mdDownloadManager = (DownloadManager) getSystemService(Context.DOWNLOAD_SERVICE);
                    DownloadManager.Request request = new DownloadManager.Request(
                            Uri.parse(url));
                    File destinationFile = new File(Environment.getExternalStorageDirectory(), fileName);                    request.setDescription("Downloading ...");
                    request.setNotificationVisibility(DownloadManager.Request.VISIBILITY_VISIBLE_NOTIFY_COMPLETED);
                    request.setDestinationUri(Uri.fromFile(destinationFile));
                    assert mdDownloadManager != null;
                    mdDownloadManager.enqueue(request);
                } else {  // その他のファイルはurlのみ確認
                    Logger.d("download ", "download URL :" + url);
                }
                return false;
            }
        });

    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (isNormalSize()) {
            setPortraitIfNormal();
        }
    }

    @Override
    public void onDestroy(){
        super.onDestroy();

        if (receiver != null) {
            unregisterReceiver(receiver);
            receiver = null;
        }
    }

    // 下辺のツールバー設定
    private void settingBottomToolbar() {
        // ホームボタン活性化
        mOperationHomeButton.setEnabled(true);
        // 共通資料ボタンの非活性化
        mOperationRelatedContentButton.setEnabled(true);
        // バッチを付けるか判定して、イメージを設定
        setCommunicationImageButton();


        // コミュニケーションボタン
        communicationButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showCommunicationMenuDialog();
            }
        });
    }

    /**
     * コミュニケーションメニューダイアログ
     */
    public void showCommunicationMenuDialog2() {
        mCommunicationMenuDialog = new Dialog(this);
        mCommunicationMenuDialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        mCommunicationMenuDialog.setCanceledOnTouchOutside(false);
        mCommunicationMenuDialog.setContentView(R.layout.communication_menu_dialog);

        List<PushMessageDto> pushMessageDtoList = pushMessageLogic.getAllPushMessageList();

        boolean existUnreadFlg = false;
        for (PushMessageDto pushMessageDto : pushMessageDtoList) {
            if (!pushMessageDto.readingFlg) {
                existUnreadFlg = true;
                break;
            }
        }

        ImageView ivIcon = (ImageView)mCommunicationMenuDialog.findViewById(R.id.btn_push_message_list);

        if (existUnreadFlg) {
            ivIcon.setBackgroundResource(R.drawable.ic_communication_push_message_list_with_badge);
        } else {
            ivIcon.setBackgroundResource(R.drawable.ic_communication_push_message_list);
        }

        LinearLayout ll_menuItem_meeting = (LinearLayout)mCommunicationMenuDialog.findViewById(R.id.ll_item_meeting);
        ll_menuItem_meeting.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                ActivityHandlingHelper.getInstance().startMeetingActivity();
                mCommunicationMenuDialog.dismiss();
            }
        });

        LinearLayout ll_menuItem_push_message = (LinearLayout)mCommunicationMenuDialog.findViewById(R.id.ll_item_push_message);
        ll_menuItem_push_message.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
//                showOperationSelectDialog();
                mCommunicationMenuDialog.dismiss();
            }
        });

        LinearLayout ll_menuItem_push_message_list = (LinearLayout)mCommunicationMenuDialog.findViewById(R.id.ll_item_push_message_list);
        ll_menuItem_push_message_list.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
//                showPushMessageListDialog();
                mCommunicationMenuDialog.dismiss();
            }
        });

        // chat
        LinearLayout ll_menuItem_chat = (LinearLayout)mCommunicationMenuDialog.findViewById(R.id.ll_item_chat);
        ll_menuItem_chat.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                // チャット利用のはネットワークが繋がる時のみ
                if (ABVEnvironment.getInstance().networkAdapter.isNetworkConnected()) {
                    ActivityHandlingHelper.getInstance().startChatWebviewActivity();
                    mCommunicationMenuDialog.dismiss();
                } else {
                    ABVToastUtil.showMakeText(ChatWebviewActivity.this, R.string.request_network_connection, Toast.LENGTH_SHORT);
                    return;
                }
            }
        });

        mCommunicationMenuDialog.findViewById(R.id.close_btn).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mCommunicationMenuDialog.dismiss();
            }
        });

        mCommunicationMenuDialog.show();
    }

    // 保存するファイルをjpgに固定する
    public String getFileName(String url) {
        String filenameWithoutExtension = "";
        filenameWithoutExtension = String.valueOf(System.currentTimeMillis()
                + ".jpg");
        return filenameWithoutExtension;
    }

    public void getLogin() {
        // ローカルの言語を確認する
        String localLanguage = ActivityHandlingHelper.getInstance().getLocaleFileName();
        // 最後のチャットのルーム名
        String lastRoomName = PreferenceUtil.getUserPref(getApplicationContext(), AppDefType.UserPrefKey.CHAT_LAST_ROOMNAME, "");
        // 最後のチャットのルーム
        String lastRoomId = PreferenceUtil.getUserPref(getApplicationContext(), AppDefType.UserPrefKey.CHAT_LAST_ROOMID, "");

        if (roomId != 0 && roomName != null) {
            // 最後のチャットのルーム名
            PreferenceUtil.putUserPref(getApplicationContext(), AppDefType.UserPrefKey.CHAT_LAST_ROOMNAME, roomName);
            // 最後のチャットのルーム
            PreferenceUtil.putUserPref(getApplicationContext(), AppDefType.UserPrefKey.CHAT_LAST_ROOMID, String.valueOf(roomId));

            mChatWebView.loadUrl(String.format("javascript:getLoginParameter('%s', '%s', '%s', '%s', '%s', '%s');", sid, loginId, shopName, roomId, roomName, localLanguage));
        } else {
            if (lastRoomName.length() > 0 && lastRoomId.length() > 0) {
                mChatWebView.loadUrl(String.format("javascript:getLoginParameter('%s', '%s', '%s', '%s', '%s', '%s');", sid, loginId, shopName, lastRoomId, lastRoomName, localLanguage));
            } else {
                mChatWebView.loadUrl(String.format("javascript:getLoginParameter('%s', '%s', '%s', undefined, undefined, '%s');", sid, loginId, shopName, localLanguage));
            }
        }
    }

    public void getQueryParam() {
        String chatServerUrl = ABVEnvironment.getInstance().websocketServerHttpUrl;
        chatServerUrl= chatServerUrl.substring(0, chatServerUrl.length() - 3);
        String cmsServerUrl = ABVEnvironment.getInstance().acmsAddress+ ABVDataCache.getInstance().getUrlPath();

        mChatWebView.loadUrl(String.format("javascript:getGlobalParam('%s', '%s', '%s', '%s', '%s');", chatServerUrl, cmsServerUrl, "android", true, isOnline));
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Uri[] result = null;
        Uri dataUri = null;
        if (data != null && resultCode == RESULT_OK) {
            String dataString = data.getDataString();
            if (dataString != null) {
                dataUri = Uri.parse(dataString);
                result = new Uri[]{dataUri};
            }
        }

        if (requestCode == ABOOK_CHECK_TASK_IMAGE) {
            if (mUploadMessage == null) {
                return;
            }
            // 画像
            try {
                if (dataUri == null) {
                    dataUri = imageUri;
                }
                Uri responseUri = attachmentImageProcessing(dataUri);
                if (responseUri != null) {
                    mUploadMessage.onReceiveValue(new Uri[]{responseUri});
                } else {
                    mUploadMessage.onReceiveValue(null);
                }
            } catch (Exception e) {
                Logger.e(TAG, e);
                mUploadMessage.onReceiveValue(null);
                ErrorMessage.showErrorMessageToast(getApplicationContext(), ErrorCode.E107);
            }
        } else if (requestCode == ABOOK_CHECK_TASK_VIDEO) {
            if (mUploadMessage == null) {
                return;
            }
            mUploadMessage.onReceiveValue(result);
        } else if (requestCode == ABOOK_CHECK_SELECT_SCENE) {
            if (data != null && result != null) {
                confirmEntrySceneDialog(result[0]);
            }
        }
        mUploadMessage = null;
    }

    /**
     * 未読のプッシュメッセージが存在するかチェック
     * @param pushMessageDtoList チェックするリスト
     * @return
     */
    private boolean checkUnReadCommunication(List<PushMessageDto> pushMessageDtoList) {
        boolean existUnreadFlg = false;
        for (PushMessageDto pushMessageDto : pushMessageDtoList) {
            if (!pushMessageDto.readingFlg) {
                existUnreadFlg = true;
                break;
            }
        }
        return existUnreadFlg;
    }

    private class JsInf {
        @JavascriptInterface
        public void saveVisitRoomInfo(String roomId, String roomName) {
            System.out.println("roomName : " + roomName);
            System.out.println("roomId : " + roomId);
            // 最後のチャットのルーム名
            PreferenceUtil.putUserPref(getApplicationContext(), AppDefType.UserPrefKey.CHAT_LAST_ROOMNAME, roomName);
            // 最後のチャットのルーム
            PreferenceUtil.putUserPref(getApplicationContext(), AppDefType.UserPrefKey.CHAT_LAST_ROOMID, roomId);
        }
        @JavascriptInterface
        public void getLoginParameter() {
            mChatWebView.post(new Runnable() {
                @Override
                public void run() {
                    getLogin();
                }
            });
        }

        @JavascriptInterface
        public void getGlobalParameter() {
            mChatWebView.post(new Runnable() {
                @Override
                public void run() {
                    getQueryParam();
                }
            });
        }

        @JavascriptInterface
        public void goHome() {
            mChatWebView.post(new Runnable() {
                @Override
                public void run() {
                    backToHome();
                }
            });

        }

        @JavascriptInterface
        public void openOperationRelatedContent() {
            mChatWebView.post(new Runnable() {
                @Override
                public void run() {
                    showCommonContent();
                }
            });
        }

        @JavascriptInterface
        public void openCommunication() {
            showCommunicationMenuDialog();
        }

        @JavascriptInterface
        public void openSetting() {
            mChatWebView.post(new Runnable() {
                @Override
                public void run() {
                    mChatWebView.loadUrl("javascript:CHAT.leaveRoom()");
                    finish();
                    showSetting();
                }
            });
        }

        @JavascriptInterface
        public void reload() {
            mChatWebView.post(new Runnable() {
                @Override
                public void run() {
                    ActivityHandlingHelper.getInstance().startChatWebviewActivity();
                }
            });

        }

        @JavascriptInterface
        public String getRoomList() {
            Map<String, Object> chatRoomList;
            String chatRoomListStr = communicationLogic.getChatRoomList();
            return chatRoomListStr;
        }

        @JavascriptInterface
        public void updateRoomList() throws NetworkDisconnectedException, AcmsException {
            Map<String, Object> chatRoomList;
            RoomListJSON resultJson = AcmsClient.getInstance(ABVEnvironment.getInstance().networkAdapter).getRoomList(sid);
            communicationLogic.deleteChatRoomList();
            communicationLogic.insertChatRoomList(resultJson.roomList);
        }
    }

    /**
     * 作業一覧へ遷移
     */
    private void backToHome() {
        mChatWebView.loadUrl("javascript:CHAT.leaveRoom()");
        finish();
        Intent intent = new Intent();
        intent.setClass(ChatWebviewActivity.this, OperationListActivity.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
        startActivity(intent, NaviConsts.Left);
    }

    /**　
     * ボタンイベント設定
     */
    private void setOnButtonEvent() {
        // 作業のホーム画面へ
        mOperationHomeButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                backToHome();
            }
        });
    }

    // 共通資料画面表示
    private void showCommonContent() {
        Intent intent = new Intent();
        intent.setClass(ChatWebviewActivity.this, OperationRelatedContentActivity.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
        startActivity(intent, NaviConsts.Left);
//        overridePendingTransition(R.anim.viewin_left_to_right, R.anim.viewin_left_to_right);
    }

    // 設定画面へ遷移
    public void onClickSetting(View v) {
        mChatWebView.loadUrl("javascript:CHAT.leaveRoom()");
        finish();
        showSetting();
    }

}
