package jp.agentec.abook.abv.ui.home.adapter;

import android.os.AsyncTask;
import android.view.View;
import android.widget.BaseAdapter;
import android.widget.ImageView;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.data.ABVDataCache;
import jp.agentec.abook.abv.bl.data.dao.AbstractDao;
import jp.agentec.abook.abv.bl.data.dao.ContentDao;
import jp.agentec.abook.abv.bl.dto.OperationDto;
import jp.agentec.abook.abv.launcher.android.R;

/**
 * Created by leej on 2019/03/06.
 */

public abstract class AbstractOperationAdapter extends BaseAdapter {
    protected AbstractOperationListAdapterListener listener;
    protected List<OperationDto> listItem = new ArrayList<>(); // NullPointException防止
    protected ContentDao mContentDao = AbstractDao.getDao(ContentDao.class);

    public interface AbstractOperationListAdapterListener {
        // 360編集
        void onPanoEdit(OperationDto operationDto);
        // 同期処理
        void onSyncOperation(OperationDto OperationDto);
        // 報告・パノラマ画像登録画面の表示
        void openReport(OperationDto OperationDto);
    }

    @Override
    public int getCount() {
        return listItem.size();
    }

    @Override
    public OperationDto getItem(int position) {
        return listItem.get(position);
    }

    @Override
    public long getItemId(int position) {
        return listItem.get(position).contentId;
    }

    public void setItem(List<OperationDto> listItem) {
        this.listItem= listItem;
        notifyDataSetChanged();
    }

    public void setAdapterListener(AbstractOperationListAdapterListener listener) {
        this.listener = listener;
    }

    // リストのタップイベントを無効にしてlayoutのonclickイベントで対応
    @Override
    public boolean isEnabled(int position) {
        return false;
    }
}
