package jp.agentec.abook.abv.ui.home.helper;

import java.util.List;

import jp.agentec.abook.abv.bl.acms.type.OperationSortingType;
import jp.agentec.abook.abv.bl.dto.OperationDto;
import jp.agentec.abook.abv.ui.home.activity.OperationListActivity;

/**
 * Created by leej on 2019/06/24.
 */

public class HomeOperationListHelper extends OperationListHelper {

    private static final String TAG = "HomeOperationListHelper";

    public HomeOperationListHelper(OperationListActivity activity) {
        super(activity);
    }

    @Override
    protected List<OperationDto> findOperationList() throws Exception {
        int operationSortType = mAppActivity.getSortCondition();
        OperationSortingType operationSortingType = OperationSortingType.parse(operationSortType);
        return operationLogic.getRefreshOperation(mAppActivity.mSearchWord, mAppActivity.mStartDateStr, mAppActivity.mEndDateStr, operationSortingType);
    }
}
