/*
 * Decompiled with CFR 0.152.
 */
package oz.util;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LightingColorFilter;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import java.util.Locale;
import oz.client.shape.ui.ICImagePickerWnd;
import oz.client.shape.ui.OZInputComponent;
import oz.main.OZStorage;
import oz.util.OZButton$OZButtonBackgroundDrawable;

public class OZButton
extends Button
implements View.OnTouchListener {
    private static final int _disabledAlpha = 100;
    private int m_action = -1;
    private OZInputComponent m_component;
    private boolean m_isResource;
    boolean pressed = false;
    private boolean auto_text_size_enable = true;
    private ColorFilter _pressedFilter = new LightingColorFilter(-3355444, 1);
    boolean isImagePickerEnglish = false;
    private boolean isNotTouch = false;

    public OZButton(Context context) {
        super(context);
    }

    public OZButton(Context context, OZInputComponent oZInputComponent) {
        super(context);
        this.m_component = oZInputComponent;
        switch (oZInputComponent.getComponentType()) {
            case 82: {
                this.setOnTouchListener(this);
                if (!Locale.US.equals(OZStorage.getViewerLocale()) || !(oZInputComponent instanceof ICImagePickerWnd) || !((ICImagePickerWnd)oZInputComponent).isMiddle()) break;
                this.isImagePickerEnglish = true;
            }
        }
    }

    public void setBackgroundDrawable(Drawable drawable2) {
        this.setBackgroundDrawable(drawable2, (ColorFilter)new LightingColorFilter(-3355444, 1), null);
    }

    public void setBackgroundDrawable(Drawable drawable2, boolean bl) {
        if (bl) {
            super.setBackgroundDrawable(drawable2);
        } else {
            this.setBackgroundDrawable(drawable2);
        }
    }

    public void setBackgroundDrawable(Drawable drawable2, ColorFilter colorFilter) {
        this.setBackgroundDrawable(drawable2, colorFilter, colorFilter);
    }

    public void setBackgroundDrawable(Drawable drawable2, ColorFilter colorFilter, ColorFilter colorFilter2) {
        OZButton$OZButtonBackgroundDrawable oZButton$OZButtonBackgroundDrawable = new OZButton$OZButtonBackgroundDrawable(this, drawable2, colorFilter, colorFilter2);
        super.setBackgroundDrawable((Drawable)oZButton$OZButtonBackgroundDrawable);
    }

    public void setAction(int n) {
        this.m_action = n;
    }

    public int getAction() {
        return this.m_action;
    }

    public boolean isResource() {
        return this.m_isResource;
    }

    public void setResource(boolean bl) {
        this.m_isResource = bl;
    }

    protected void onMeasure(int n, int n2) {
        if (this.isImagePickerEnglish && !this.m_isResource) {
            super.onMeasure(n2, n);
            this.setMeasuredDimension(this.getMeasuredHeight(), this.getMeasuredWidth());
        } else {
            super.onMeasure(n, n2);
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.isImagePickerEnglish && !this.m_isResource) {
            TextPaint textPaint = this.getPaint();
            textPaint.setColor(this.getCurrentTextColor());
            textPaint.drawableState = this.getDrawableState();
            canvas.save();
            canvas.translate((float)this.getWidth(), 0.0f);
            canvas.rotate(90.0f);
            canvas.translate((float)this.getCompoundPaddingLeft(), ((float)this.getMeasuredWidth() - this.getTextSize()) / 2.0f - textPaint.descent());
            this.getLayout().draw(canvas);
            canvas.restore();
        } else {
            super.onDraw(canvas);
        }
    }

    public void setNotTouch(boolean bl) {
        this.isNotTouch = bl;
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        if (this.isNotTouch) {
            return true;
        }
        switch (motionEvent.getAction()) {
            case 0: {
                this.pressed = true;
                break;
            }
            case 1: {
                this.pressed = false;
            }
        }
        return super.onTouchEvent(motionEvent);
    }

    public boolean isAutoTextSize() {
        return this.auto_text_size_enable;
    }

    public void setAutoTextSize(boolean bl) {
        this.auto_text_size_enable = bl;
    }
}

