/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.android.common;

import android.os.Build;
import android.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class PlatformSupportManager {
    private static final String TAG = PlatformSupportManager.class.getSimpleName();
    private final Class managedInterface;
    private final Object defaultImplementation;
    private final SortedMap implementations;

    protected PlatformSupportManager(Class clazz, Object object) {
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException();
        }
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException();
        }
        this.managedInterface = clazz;
        this.defaultImplementation = object;
        this.implementations = new TreeMap(Collections.reverseOrder());
    }

    protected final void addImplementationClass(int n, String string) {
        this.implementations.put(n, string);
    }

    public final Object build() {
        for (Integer n : this.implementations.keySet()) {
            if (Build.VERSION.SDK_INT < n) continue;
            String string = (String)this.implementations.get(n);
            try {
                Class clazz = Class.forName(string).asSubclass(this.managedInterface);
                Log.i((String)TAG, (String)("Using implementation " + clazz + " of " + this.managedInterface + " for SDK " + n));
                return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Log.w((String)TAG, (Throwable)classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.w((String)TAG, (Throwable)illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                Log.w((String)TAG, (Throwable)instantiationException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Log.w((String)TAG, (Throwable)noSuchMethodException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.w((String)TAG, (Throwable)invocationTargetException);
            }
        }
        Log.i((String)TAG, (String)("Using default implementation " + this.defaultImplementation.getClass() + " of " + this.managedInterface));
        return this.defaultImplementation;
    }
}

