/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.common;

import oz.util.barcode.Binarizer;
import oz.util.barcode.LuminanceSource;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.common.GlobalHistogramBinarizer;

public final class HybridBinarizer
extends GlobalHistogramBinarizer {
    private static final int BLOCK_SIZE_POWER = 3;
    private static final int BLOCK_SIZE = 8;
    private static final int BLOCK_SIZE_MASK = 7;
    private static final int MINIMUM_DIMENSION = 40;
    private static final int MIN_DYNAMIC_RANGE = 24;
    private BitMatrix matrix;

    public HybridBinarizer(LuminanceSource luminanceSource) {
        super(luminanceSource);
    }

    @Override
    public BitMatrix getBlackMatrix() {
        if (this.matrix != null) {
            return this.matrix;
        }
        LuminanceSource luminanceSource = this.getLuminanceSource();
        int n = luminanceSource.getWidth();
        int n2 = luminanceSource.getHeight();
        if (n >= 40 && n2 >= 40) {
            byte[] byArray = luminanceSource.getMatrix();
            int n3 = n >> 3;
            if ((n & 7) != 0) {
                ++n3;
            }
            int n4 = n2 >> 3;
            if ((n2 & 7) != 0) {
                ++n4;
            }
            int[][] nArray = HybridBinarizer.calculateBlackPoints(byArray, n3, n4, n, n2);
            BitMatrix bitMatrix = new BitMatrix(n, n2);
            HybridBinarizer.calculateThresholdForBlock(byArray, n3, n4, n, n2, nArray, bitMatrix);
            this.matrix = bitMatrix;
        } else {
            this.matrix = super.getBlackMatrix();
        }
        return this.matrix;
    }

    @Override
    public Binarizer createBinarizer(LuminanceSource luminanceSource) {
        return new HybridBinarizer(luminanceSource);
    }

    private static void calculateThresholdForBlock(byte[] byArray, int n, int n2, int n3, int n4, int[][] nArray, BitMatrix bitMatrix) {
        int n5 = 0;
        while (n5 < n2) {
            int n6 = n5 << 3;
            int n7 = n4 - 8;
            if (n6 > n7) {
                n6 = n7;
            }
            int n8 = 0;
            while (n8 < n) {
                int n9 = n8 << 3;
                int n10 = n3 - 8;
                if (n9 > n10) {
                    n9 = n10;
                }
                int n11 = HybridBinarizer.cap(n8, 2, n - 3);
                int n12 = HybridBinarizer.cap(n5, 2, n2 - 3);
                int n13 = 0;
                int n14 = -2;
                while (n14 <= 2) {
                    int[] nArray2 = nArray[n12 + n14];
                    n13 += nArray2[n11 - 2] + nArray2[n11 - 1] + nArray2[n11] + nArray2[n11 + 1] + nArray2[n11 + 2];
                    ++n14;
                }
                n14 = n13 / 25;
                HybridBinarizer.thresholdBlock(byArray, n9, n6, n14, n3, bitMatrix);
                ++n8;
            }
            ++n5;
        }
    }

    private static int cap(int n, int n2, int n3) {
        return n < n2 ? n2 : (n > n3 ? n3 : n);
    }

    private static void thresholdBlock(byte[] byArray, int n, int n2, int n3, int n4, BitMatrix bitMatrix) {
        int n5 = 0;
        int n6 = n2 * n4 + n;
        while (n5 < 8) {
            int n7 = 0;
            while (n7 < 8) {
                if ((byArray[n6 + n7] & 0xFF) <= n3) {
                    bitMatrix.set(n + n7, n2 + n5);
                }
                ++n7;
            }
            ++n5;
            n6 += n4;
        }
    }

    private static int[][] calculateBlackPoints(byte[] byArray, int n, int n2, int n3, int n4) {
        int[][] nArray = new int[n2][n];
        int n5 = 0;
        while (n5 < n2) {
            int n6 = n5 << 3;
            int n7 = n4 - 8;
            if (n6 > n7) {
                n6 = n7;
            }
            int n8 = 0;
            while (n8 < n) {
                int n9 = n8 << 3;
                int n10 = n3 - 8;
                if (n9 > n10) {
                    n9 = n10;
                }
                int n11 = 0;
                int n12 = 255;
                int n13 = 0;
                int n14 = 0;
                int n15 = n6 * n3 + n9;
                while (n14 < 8) {
                    int n16 = 0;
                    while (n16 < 8) {
                        int n17 = byArray[n15 + n16] & 0xFF;
                        n11 += n17;
                        if (n17 < n12) {
                            n12 = n17;
                        }
                        if (n17 > n13) {
                            n13 = n17;
                        }
                        ++n16;
                    }
                    if (n13 - n12 > 24) {
                        ++n14;
                        n15 += n3;
                        while (n14 < 8) {
                            n16 = 0;
                            while (n16 < 8) {
                                n11 += byArray[n15 + n16] & 0xFF;
                                ++n16;
                            }
                            ++n14;
                            n15 += n3;
                        }
                    }
                    ++n14;
                    n15 += n3;
                }
                n14 = n11 >> 6;
                if (n13 - n12 <= 24) {
                    n14 = n12 >> 1;
                    if (n5 > 0 && n8 > 0 && n12 < (n15 = nArray[n5 - 1][n8] + 2 * nArray[n5][n8 - 1] + nArray[n5 - 1][n8 - 1] >> 2)) {
                        n14 = n15;
                    }
                }
                nArray[n5][n8] = n14;
                ++n8;
            }
            ++n5;
        }
        return nArray;
    }
}

