/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.datamatrix.decoder;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import oz.util.barcode.FormatException;
import oz.util.barcode.common.BitSource;
import oz.util.barcode.common.DecoderResult;
import oz.util.barcode.datamatrix.decoder.DecodedBitStreamParser$Mode;

final class DecodedBitStreamParser {
    private static final char[] C40_BASIC_SET_CHARS = new char[]{'*', '*', '*', ' ', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] C40_SHIFT2_SET_CHARS = new char[]{'!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '^', '_'};
    private static final char[] TEXT_BASIC_SET_CHARS = new char[]{'*', '*', '*', ' ', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] TEXT_SHIFT3_SET_CHARS = new char[]{'`', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '{', '|', '}', '~', '\u007f'};

    private DecodedBitStreamParser() {
    }

    static DecoderResult decode(byte[] byArray) {
        BitSource bitSource = new BitSource(byArray);
        StringBuilder stringBuilder = new StringBuilder(100);
        StringBuilder stringBuilder2 = new StringBuilder(0);
        ArrayList arrayList = new ArrayList(1);
        DecodedBitStreamParser$Mode decodedBitStreamParser$Mode = DecodedBitStreamParser$Mode.ASCII_ENCODE;
        do {
            if (decodedBitStreamParser$Mode == DecodedBitStreamParser$Mode.ASCII_ENCODE) {
                decodedBitStreamParser$Mode = DecodedBitStreamParser.decodeAsciiSegment(bitSource, stringBuilder, stringBuilder2);
                continue;
            }
            switch (decodedBitStreamParser$Mode) {
                case C40_ENCODE: {
                    DecodedBitStreamParser.decodeC40Segment(bitSource, stringBuilder);
                    break;
                }
                case TEXT_ENCODE: {
                    DecodedBitStreamParser.decodeTextSegment(bitSource, stringBuilder);
                    break;
                }
                case ANSIX12_ENCODE: {
                    DecodedBitStreamParser.decodeAnsiX12Segment(bitSource, stringBuilder);
                    break;
                }
                case EDIFACT_ENCODE: {
                    DecodedBitStreamParser.decodeEdifactSegment(bitSource, stringBuilder);
                    break;
                }
                case BASE256_ENCODE: {
                    DecodedBitStreamParser.decodeBase256Segment(bitSource, stringBuilder, arrayList);
                    break;
                }
                default: {
                    throw FormatException.getFormatInstance();
                }
            }
            decodedBitStreamParser$Mode = DecodedBitStreamParser$Mode.ASCII_ENCODE;
        } while (decodedBitStreamParser$Mode != DecodedBitStreamParser$Mode.PAD_ENCODE && bitSource.available() > 0);
        if (stringBuilder2.length() > 0) {
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        return new DecoderResult(byArray, stringBuilder.toString(), arrayList.isEmpty() ? null : arrayList, null);
    }

    private static DecodedBitStreamParser$Mode decodeAsciiSegment(BitSource bitSource, StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        boolean bl = false;
        do {
            int n;
            if ((n = bitSource.readBits(8)) == 0) {
                throw FormatException.getFormatInstance();
            }
            if (n <= 128) {
                if (bl) {
                    n += 128;
                }
                stringBuilder.append((char)(n - 1));
                return DecodedBitStreamParser$Mode.ASCII_ENCODE;
            }
            if (n == 129) {
                return DecodedBitStreamParser$Mode.PAD_ENCODE;
            }
            if (n <= 229) {
                int n2 = n - 130;
                if (n2 < 10) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(n2);
                continue;
            }
            if (n == 230) {
                return DecodedBitStreamParser$Mode.C40_ENCODE;
            }
            if (n == 231) {
                return DecodedBitStreamParser$Mode.BASE256_ENCODE;
            }
            if (n == 232) {
                stringBuilder.append('\u001d');
                continue;
            }
            if (n == 233 || n == 234) continue;
            if (n == 235) {
                bl = true;
                continue;
            }
            if (n == 236) {
                stringBuilder.append("[)>\u001e05\u001d");
                stringBuilder2.insert(0, "\u001e\u0004");
                continue;
            }
            if (n == 237) {
                stringBuilder.append("[)>\u001e06\u001d");
                stringBuilder2.insert(0, "\u001e\u0004");
                continue;
            }
            if (n == 238) {
                return DecodedBitStreamParser$Mode.ANSIX12_ENCODE;
            }
            if (n == 239) {
                return DecodedBitStreamParser$Mode.TEXT_ENCODE;
            }
            if (n == 240) {
                return DecodedBitStreamParser$Mode.EDIFACT_ENCODE;
            }
            if (n == 241 || n < 242 || n == 254 && bitSource.available() == 0) continue;
            throw FormatException.getFormatInstance();
        } while (bitSource.available() > 0);
        return DecodedBitStreamParser$Mode.ASCII_ENCODE;
    }

    private static void decodeC40Segment(BitSource bitSource, StringBuilder stringBuilder) {
        boolean bl = false;
        int[] nArray = new int[3];
        int n = 0;
        do {
            if (bitSource.available() == 8) {
                return;
            }
            int n2 = bitSource.readBits(8);
            if (n2 == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(n2, bitSource.readBits(8), nArray);
            int n3 = 0;
            while (n3 < 3) {
                int n4 = nArray[n3];
                switch (n) {
                    case 0: {
                        char c2;
                        if (n4 < 3) {
                            n = n4 + 1;
                            break;
                        }
                        if (n4 < C40_BASIC_SET_CHARS.length) {
                            c2 = C40_BASIC_SET_CHARS[n4];
                            if (bl) {
                                stringBuilder.append((char)(c2 + 128));
                                bl = false;
                                break;
                            }
                            stringBuilder.append(c2);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case 1: {
                        if (bl) {
                            stringBuilder.append((char)(n4 + 128));
                            bl = false;
                        } else {
                            stringBuilder.append((char)n4);
                        }
                        n = 0;
                        break;
                    }
                    case 2: {
                        char c2;
                        if (n4 < C40_SHIFT2_SET_CHARS.length) {
                            c2 = C40_SHIFT2_SET_CHARS[n4];
                            if (bl) {
                                stringBuilder.append((char)(c2 + 128));
                                bl = false;
                            } else {
                                stringBuilder.append(c2);
                            }
                        } else if (n4 == 27) {
                            stringBuilder.append('\u001d');
                        } else if (n4 == 30) {
                            bl = true;
                        } else {
                            throw FormatException.getFormatInstance();
                        }
                        n = 0;
                        break;
                    }
                    case 3: {
                        if (bl) {
                            stringBuilder.append((char)(n4 + 224));
                            bl = false;
                        } else {
                            stringBuilder.append((char)(n4 + 96));
                        }
                        n = 0;
                        break;
                    }
                    default: {
                        throw FormatException.getFormatInstance();
                    }
                }
                ++n3;
            }
        } while (bitSource.available() > 0);
    }

    private static void decodeTextSegment(BitSource bitSource, StringBuilder stringBuilder) {
        boolean bl = false;
        int[] nArray = new int[3];
        int n = 0;
        do {
            if (bitSource.available() == 8) {
                return;
            }
            int n2 = bitSource.readBits(8);
            if (n2 == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(n2, bitSource.readBits(8), nArray);
            int n3 = 0;
            while (n3 < 3) {
                int n4 = nArray[n3];
                switch (n) {
                    case 0: {
                        char c2;
                        if (n4 < 3) {
                            n = n4 + 1;
                            break;
                        }
                        if (n4 < TEXT_BASIC_SET_CHARS.length) {
                            c2 = TEXT_BASIC_SET_CHARS[n4];
                            if (bl) {
                                stringBuilder.append((char)(c2 + 128));
                                bl = false;
                                break;
                            }
                            stringBuilder.append(c2);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case 1: {
                        if (bl) {
                            stringBuilder.append((char)(n4 + 128));
                            bl = false;
                        } else {
                            stringBuilder.append((char)n4);
                        }
                        n = 0;
                        break;
                    }
                    case 2: {
                        char c2;
                        if (n4 < C40_SHIFT2_SET_CHARS.length) {
                            c2 = C40_SHIFT2_SET_CHARS[n4];
                            if (bl) {
                                stringBuilder.append((char)(c2 + 128));
                                bl = false;
                            } else {
                                stringBuilder.append(c2);
                            }
                        } else if (n4 == 27) {
                            stringBuilder.append('\u001d');
                        } else if (n4 == 30) {
                            bl = true;
                        } else {
                            throw FormatException.getFormatInstance();
                        }
                        n = 0;
                        break;
                    }
                    case 3: {
                        char c2;
                        if (n4 < TEXT_SHIFT3_SET_CHARS.length) {
                            c2 = TEXT_SHIFT3_SET_CHARS[n4];
                            if (bl) {
                                stringBuilder.append((char)(c2 + 128));
                                bl = false;
                            } else {
                                stringBuilder.append(c2);
                            }
                            n = 0;
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    default: {
                        throw FormatException.getFormatInstance();
                    }
                }
                ++n3;
            }
        } while (bitSource.available() > 0);
    }

    private static void decodeAnsiX12Segment(BitSource bitSource, StringBuilder stringBuilder) {
        int[] nArray = new int[3];
        do {
            if (bitSource.available() == 8) {
                return;
            }
            int n = bitSource.readBits(8);
            if (n == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(n, bitSource.readBits(8), nArray);
            int n2 = 0;
            while (n2 < 3) {
                int n3 = nArray[n2];
                if (n3 == 0) {
                    stringBuilder.append('\r');
                } else if (n3 == 1) {
                    stringBuilder.append('*');
                } else if (n3 == 2) {
                    stringBuilder.append('>');
                } else if (n3 == 3) {
                    stringBuilder.append(' ');
                } else if (n3 < 14) {
                    stringBuilder.append((char)(n3 + 44));
                } else if (n3 < 40) {
                    stringBuilder.append((char)(n3 + 51));
                } else {
                    throw FormatException.getFormatInstance();
                }
                ++n2;
            }
        } while (bitSource.available() > 0);
    }

    private static void parseTwoBytes(int n, int n2, int[] nArray) {
        int n3;
        int n4 = (n << 8) + n2 - 1;
        nArray[0] = n3 = n4 / 1600;
        n4 -= n3 * 1600;
        nArray[1] = n3 = n4 / 40;
        nArray[2] = n4 - n3 * 40;
    }

    private static void decodeEdifactSegment(BitSource bitSource, StringBuilder stringBuilder) {
        do {
            if (bitSource.available() <= 16) {
                return;
            }
            int n = 0;
            while (n < 4) {
                int n2 = bitSource.readBits(6);
                if (n2 == 31) {
                    int n3 = 8 - bitSource.getBitOffset();
                    if (n3 != 8) {
                        bitSource.readBits(n3);
                    }
                    return;
                }
                if ((n2 & 0x20) == 0) {
                    n2 |= 0x40;
                }
                stringBuilder.append((char)n2);
                ++n;
            }
        } while (bitSource.available() > 0);
    }

    private static void decodeBase256Segment(BitSource bitSource, StringBuilder stringBuilder, Collection collection) {
        int n = 1 + bitSource.getByteOffset();
        int n2 = DecodedBitStreamParser.unrandomize255State(bitSource.readBits(8), n++);
        int n3 = n2 == 0 ? bitSource.available() / 8 : (n2 < 250 ? n2 : 250 * (n2 - 249) + DecodedBitStreamParser.unrandomize255State(bitSource.readBits(8), n++));
        if (n3 < 0) {
            throw FormatException.getFormatInstance();
        }
        byte[] byArray = new byte[n3];
        int n4 = 0;
        while (n4 < n3) {
            if (bitSource.available() < 8) {
                throw FormatException.getFormatInstance();
            }
            byArray[n4] = (byte)DecodedBitStreamParser.unrandomize255State(bitSource.readBits(8), n++);
            ++n4;
        }
        collection.add(byArray);
        try {
            stringBuilder.append(new String(byArray, "ISO8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Platform does not support required encoding: " + unsupportedEncodingException);
        }
    }

    private static int unrandomize255State(int n, int n2) {
        int n3 = 149 * n2 % 255 + 1;
        int n4 = n - n3;
        return n4 >= 0 ? n4 : n4 + 256;
    }
}

