/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.datamatrix.encoder;

import oz.util.barcode.datamatrix.encoder.Encoder;
import oz.util.barcode.datamatrix.encoder.EncoderContext;
import oz.util.barcode.datamatrix.encoder.HighLevelEncoder;

final class ASCIIEncoder
implements Encoder {
    ASCIIEncoder() {
    }

    @Override
    public int getEncodingMode() {
        return 0;
    }

    @Override
    public void encode(EncoderContext encoderContext) {
        block10: {
            char c2;
            block11: {
                block9: {
                    int n = HighLevelEncoder.determineConsecutiveDigitCount(encoderContext.getMessage(), encoderContext.pos);
                    if (n < 2) break block9;
                    encoderContext.writeCodeword(ASCIIEncoder.encodeASCIIDigits(encoderContext.getMessage().charAt(encoderContext.pos), encoderContext.getMessage().charAt(encoderContext.pos + 1)));
                    encoderContext.pos += 2;
                    break block10;
                }
                c2 = encoderContext.getCurrentChar();
                int n = HighLevelEncoder.lookAheadTest(encoderContext.getMessage(), encoderContext.pos, this.getEncodingMode());
                if (n == this.getEncodingMode()) break block11;
                switch (n) {
                    case 5: {
                        encoderContext.writeCodeword('\u00e7');
                        encoderContext.signalEncoderChange(5);
                        return;
                    }
                    case 1: {
                        encoderContext.writeCodeword('\u00e6');
                        encoderContext.signalEncoderChange(1);
                        return;
                    }
                    case 3: {
                        encoderContext.writeCodeword('\u00ee');
                        encoderContext.signalEncoderChange(3);
                        break block10;
                    }
                    case 2: {
                        encoderContext.writeCodeword('\u00ef');
                        encoderContext.signalEncoderChange(2);
                        break block10;
                    }
                    case 4: {
                        encoderContext.writeCodeword('\u00f0');
                        encoderContext.signalEncoderChange(4);
                        break block10;
                    }
                    default: {
                        throw new IllegalStateException("Illegal mode: " + n);
                    }
                }
            }
            if (HighLevelEncoder.isExtendedASCII(c2)) {
                encoderContext.writeCodeword('\u00eb');
                encoderContext.writeCodeword((char)(c2 - 128 + 1));
                ++encoderContext.pos;
            } else {
                encoderContext.writeCodeword((char)(c2 + '\u0001'));
                ++encoderContext.pos;
            }
        }
    }

    private static char encodeASCIIDigits(char c2, char c3) {
        if (HighLevelEncoder.isDigit(c2) && HighLevelEncoder.isDigit(c3)) {
            int n = (c2 - 48) * 10 + (c3 - 48);
            return (char)(n + 130);
        }
        throw new IllegalArgumentException("not digits: " + c2 + c3);
    }
}

