/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.pdf417.decoder;

import oz.util.barcode.FormatException;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.pdf417.decoder.BarcodeMetadata;
import oz.util.barcode.pdf417.decoder.BarcodeValue;
import oz.util.barcode.pdf417.decoder.BoundingBox;
import oz.util.barcode.pdf417.decoder.Codeword;
import oz.util.barcode.pdf417.decoder.DetectionResultColumn;

final class DetectionResultRowIndicatorColumn
extends DetectionResultColumn {
    private final boolean isLeft;

    DetectionResultRowIndicatorColumn(BoundingBox boundingBox, boolean bl) {
        super(boundingBox);
        this.isLeft = bl;
    }

    void setRowNumbers() {
        Codeword[] codewordArray = this.getCodewords();
        int n = codewordArray.length;
        int n2 = 0;
        while (n2 < n) {
            Codeword codeword = codewordArray[n2];
            if (codeword != null) {
                codeword.setRowNumberAsRowIndicatorColumn();
            }
            ++n2;
        }
    }

    int adjustCompleteIndicatorColumnRowNumbers(BarcodeMetadata barcodeMetadata) {
        Codeword[] codewordArray = this.getCodewords();
        this.setRowNumbers();
        this.removeIncorrectCodewords(codewordArray, barcodeMetadata);
        BoundingBox boundingBox = this.getBoundingBox();
        ResultPoint resultPoint = this.isLeft ? boundingBox.getTopLeft() : boundingBox.getTopRight();
        ResultPoint resultPoint2 = this.isLeft ? boundingBox.getBottomLeft() : boundingBox.getBottomRight();
        int n = this.imageRowToCodewordIndex((int)resultPoint.getY());
        int n2 = this.imageRowToCodewordIndex((int)resultPoint2.getY());
        float f2 = (float)(n2 - n) / (float)barcodeMetadata.getRowCount();
        int n3 = -1;
        int n4 = 1;
        int n5 = 0;
        int n6 = n;
        while (n6 < n2) {
            if (codewordArray[n6] != null) {
                Codeword codeword = codewordArray[n6];
                int n7 = codeword.getRowNumber() - n3;
                if (n7 == 0) {
                    ++n5;
                } else if (n7 == 1) {
                    n4 = Math.max(n4, n5);
                    n5 = 1;
                    n3 = codeword.getRowNumber();
                } else if (n7 < 0 || codeword.getRowNumber() >= barcodeMetadata.getRowCount() || n7 > n6) {
                    codewordArray[n6] = null;
                } else {
                    int n8 = n4 > 2 ? (n4 - 2) * n7 : n7;
                    boolean bl = n8 >= n6;
                    int n9 = 1;
                    while (n9 <= n8 && !bl) {
                        bl = codewordArray[n6 - n9] != null;
                        ++n9;
                    }
                    if (bl) {
                        codewordArray[n6] = null;
                    } else {
                        n3 = codeword.getRowNumber();
                        n5 = 1;
                    }
                }
            }
            ++n6;
        }
        return (int)((double)f2 + 0.5);
    }

    int[] getRowHeights() {
        BarcodeMetadata barcodeMetadata = this.getBarcodeMetadata();
        if (barcodeMetadata == null) {
            return null;
        }
        this.adjustIncompleteIndicatorColumnRowNumbers(barcodeMetadata);
        int[] nArray = new int[barcodeMetadata.getRowCount()];
        Codeword[] codewordArray = this.getCodewords();
        int n = codewordArray.length;
        int n2 = 0;
        while (n2 < n) {
            Codeword codeword = codewordArray[n2];
            if (codeword != null) {
                int n3 = codeword.getRowNumber();
                if (n3 >= nArray.length) {
                    throw FormatException.getFormatInstance();
                }
                int n4 = n3;
                nArray[n4] = nArray[n4] + 1;
            }
            ++n2;
        }
        return nArray;
    }

    int adjustIncompleteIndicatorColumnRowNumbers(BarcodeMetadata barcodeMetadata) {
        BoundingBox boundingBox = this.getBoundingBox();
        ResultPoint resultPoint = this.isLeft ? boundingBox.getTopLeft() : boundingBox.getTopRight();
        ResultPoint resultPoint2 = this.isLeft ? boundingBox.getBottomLeft() : boundingBox.getBottomRight();
        int n = this.imageRowToCodewordIndex((int)resultPoint.getY());
        int n2 = this.imageRowToCodewordIndex((int)resultPoint2.getY());
        float f2 = (float)(n2 - n) / (float)barcodeMetadata.getRowCount();
        Codeword[] codewordArray = this.getCodewords();
        int n3 = -1;
        int n4 = 1;
        int n5 = 0;
        int n6 = n;
        while (n6 < n2) {
            if (codewordArray[n6] != null) {
                Codeword codeword = codewordArray[n6];
                codeword.setRowNumberAsRowIndicatorColumn();
                int n7 = codeword.getRowNumber() - n3;
                if (n7 == 0) {
                    ++n5;
                } else if (n7 == 1) {
                    n4 = Math.max(n4, n5);
                    n5 = 1;
                    n3 = codeword.getRowNumber();
                } else if (codeword.getRowNumber() >= barcodeMetadata.getRowCount()) {
                    codewordArray[n6] = null;
                } else {
                    n3 = codeword.getRowNumber();
                    n5 = 1;
                }
            }
            ++n6;
        }
        return (int)((double)f2 + 0.5);
    }

    BarcodeMetadata getBarcodeMetadata() {
        Object object;
        Codeword[] codewordArray = this.getCodewords();
        BarcodeValue barcodeValue = new BarcodeValue();
        BarcodeValue barcodeValue2 = new BarcodeValue();
        BarcodeValue barcodeValue3 = new BarcodeValue();
        BarcodeValue barcodeValue4 = new BarcodeValue();
        Codeword[] codewordArray2 = codewordArray;
        int n = codewordArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = codewordArray2[n2];
            if (object != null) {
                ((Codeword)object).setRowNumberAsRowIndicatorColumn();
                int n3 = ((Codeword)object).getValue() % 30;
                int n4 = ((Codeword)object).getRowNumber();
                if (!this.isLeft) {
                    n4 += 2;
                }
                switch (n4 % 3) {
                    case 0: {
                        barcodeValue2.setValue(n3 * 3 + 1);
                        break;
                    }
                    case 1: {
                        barcodeValue4.setValue(n3 / 3);
                        barcodeValue3.setValue(n3 % 3);
                        break;
                    }
                    case 2: {
                        barcodeValue.setValue(n3 + 1);
                    }
                }
            }
            ++n2;
        }
        if (barcodeValue.getValue().length == 0 || barcodeValue2.getValue().length == 0 || barcodeValue3.getValue().length == 0 || barcodeValue4.getValue().length == 0 || barcodeValue.getValue()[0] < 1 || barcodeValue2.getValue()[0] + barcodeValue3.getValue()[0] < 3 || barcodeValue2.getValue()[0] + barcodeValue3.getValue()[0] > 90) {
            return null;
        }
        object = new BarcodeMetadata(barcodeValue.getValue()[0], barcodeValue2.getValue()[0], barcodeValue3.getValue()[0], barcodeValue4.getValue()[0]);
        this.removeIncorrectCodewords(codewordArray, (BarcodeMetadata)object);
        return object;
    }

    private void removeIncorrectCodewords(Codeword[] codewordArray, BarcodeMetadata barcodeMetadata) {
        int n = 0;
        while (n < codewordArray.length) {
            Codeword codeword = codewordArray[n];
            if (codewordArray[n] != null) {
                int n2 = codeword.getValue() % 30;
                int n3 = codeword.getRowNumber();
                if (n3 > barcodeMetadata.getRowCount()) {
                    codewordArray[n] = null;
                } else {
                    if (!this.isLeft) {
                        n3 += 2;
                    }
                    switch (n3 % 3) {
                        case 0: {
                            if (n2 * 3 + 1 == barcodeMetadata.getRowCountUpperPart()) break;
                            codewordArray[n] = null;
                            break;
                        }
                        case 1: {
                            if (n2 / 3 == barcodeMetadata.getErrorCorrectionLevel() && n2 % 3 == barcodeMetadata.getRowCountLowerPart()) break;
                            codewordArray[n] = null;
                            break;
                        }
                        case 2: {
                            if (n2 + 1 == barcodeMetadata.getColumnCount()) break;
                            codewordArray[n] = null;
                        }
                    }
                }
            }
            ++n;
        }
    }

    boolean isLeft() {
        return this.isLeft;
    }

    @Override
    public String toString() {
        return "IsLeft: " + this.isLeft + '\n' + super.toString();
    }
}

