/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.qrcode.detector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oz.util.barcode.DecodeHintType;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.ResultPointCallback;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.qrcode.detector.FinderPattern;
import oz.util.barcode.qrcode.detector.FinderPatternFinder$CenterComparator;
import oz.util.barcode.qrcode.detector.FinderPatternFinder$FurthestFromAverageComparator;
import oz.util.barcode.qrcode.detector.FinderPatternInfo;

public class FinderPatternFinder {
    private static final int CENTER_QUORUM = 2;
    protected static final int MIN_SKIP = 3;
    protected static final int MAX_MODULES = 57;
    private final BitMatrix image;
    private final List possibleCenters;
    private boolean hasSkipped;
    private final int[] crossCheckStateCount;
    private final ResultPointCallback resultPointCallback;

    public FinderPatternFinder(BitMatrix bitMatrix) {
        this(bitMatrix, null);
    }

    public FinderPatternFinder(BitMatrix bitMatrix, ResultPointCallback resultPointCallback) {
        this.image = bitMatrix;
        this.possibleCenters = new ArrayList();
        this.crossCheckStateCount = new int[5];
        this.resultPointCallback = resultPointCallback;
    }

    protected final BitMatrix getImage() {
        return this.image;
    }

    protected final List getPossibleCenters() {
        return this.possibleCenters;
    }

    final FinderPatternInfo find(Map map) {
        boolean bl = map != null && map.containsKey((Object)DecodeHintType.TRY_HARDER);
        boolean bl2 = map != null && map.containsKey((Object)DecodeHintType.PURE_BARCODE);
        int n = this.image.getHeight();
        int n2 = this.image.getWidth();
        int n3 = 3 * n / 228;
        if (n3 < 3 || bl) {
            n3 = 3;
        }
        boolean bl3 = false;
        int[] nArray = new int[5];
        int n4 = n3 - 1;
        while (n4 < n && !bl3) {
            nArray[0] = 0;
            nArray[1] = 0;
            nArray[2] = 0;
            nArray[3] = 0;
            nArray[4] = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < n2) {
                if (this.image.get(n6, n4)) {
                    if (n5 & true) {
                        // empty if block
                    }
                    int n7 = ++n5;
                    nArray[n7] = nArray[n7] + 1;
                } else if (!(n5 & true)) {
                    if (n5 == 4) {
                        if (FinderPatternFinder.foundPatternCross(nArray)) {
                            boolean bl4 = this.handlePossibleCenter(nArray, n4, n6, bl2);
                            if (!bl4) {
                                nArray[0] = nArray[2];
                                nArray[1] = nArray[3];
                                nArray[2] = nArray[4];
                                nArray[3] = 1;
                                nArray[4] = 0;
                                n5 = 3;
                            } else {
                                n3 = 2;
                                if (this.hasSkipped) {
                                    bl3 = this.haveMultiplyConfirmedCenters();
                                } else {
                                    int n8 = this.findRowSkip();
                                    if (n8 > nArray[2]) {
                                        n4 += n8 - nArray[2] - n3;
                                        n6 = n2 - 1;
                                    }
                                }
                                n5 = 0;
                                nArray[0] = 0;
                                nArray[1] = 0;
                                nArray[2] = 0;
                                nArray[3] = 0;
                                nArray[4] = 0;
                            }
                        } else {
                            nArray[0] = nArray[2];
                            nArray[1] = nArray[3];
                            nArray[2] = nArray[4];
                            nArray[3] = 1;
                            nArray[4] = 0;
                            n5 = 3;
                        }
                    } else {
                        int n9 = ++n5;
                        nArray[n9] = nArray[n9] + 1;
                    }
                } else {
                    int n10 = n5;
                    nArray[n10] = nArray[n10] + 1;
                }
                ++n6;
            }
            if (FinderPatternFinder.foundPatternCross(nArray) && (n6 = (int)(this.handlePossibleCenter(nArray, n4, n2, bl2) ? 1 : 0)) != 0) {
                n3 = nArray[0];
                if (this.hasSkipped) {
                    bl3 = this.haveMultiplyConfirmedCenters();
                }
            }
            n4 += n3;
        }
        ResultPoint[] resultPointArray = this.selectBestPatterns();
        ResultPoint.orderBestPatterns(resultPointArray);
        return new FinderPatternInfo((FinderPattern[])resultPointArray);
    }

    private static float centerFromEnd(int[] nArray, int n) {
        return (float)(n - nArray[4] - nArray[3]) - (float)nArray[2] / 2.0f;
    }

    protected static boolean foundPatternCross(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < 5) {
            int n3 = nArray[n2];
            if (n3 == 0) {
                return false;
            }
            n += n3;
            ++n2;
        }
        if (n < 7) {
            return false;
        }
        float f2 = (float)n / 7.0f;
        float f3 = f2 / 2.0f;
        return Math.abs(f2 - (float)nArray[0]) < f3 && Math.abs(f2 - (float)nArray[1]) < f3 && Math.abs(3.0f * f2 - (float)nArray[2]) < 3.0f * f3 && Math.abs(f2 - (float)nArray[3]) < f3 && Math.abs(f2 - (float)nArray[4]) < f3;
    }

    private int[] getCrossCheckStateCount() {
        this.crossCheckStateCount[0] = 0;
        this.crossCheckStateCount[1] = 0;
        this.crossCheckStateCount[2] = 0;
        this.crossCheckStateCount[3] = 0;
        this.crossCheckStateCount[4] = 0;
        return this.crossCheckStateCount;
    }

    /*
     * Unable to fully structure code
     */
    private boolean crossCheckDiagonal(int var1_1, int var2_2, int var3_3, int var4_4) {
        var5_5 = this.getCrossCheckStateCount();
        var6_6 = 0;
        while (var1_1 >= var6_6 && var2_2 >= var6_6 && this.image.get(var2_2 - var6_6, var1_1 - var6_6)) {
            var5_5[2] = var5_5[2] + 1;
            ++var6_6;
        }
        if (var1_1 >= var6_6 && var2_2 >= var6_6) ** GOTO lbl11
        return false;
lbl-1000:
        // 1 sources

        {
            var5_5[1] = var5_5[1] + 1;
            ++var6_6;
lbl11:
            // 2 sources

            ** while (var1_1 >= var6_6 && var2_2 >= var6_6 && !this.image.get((int)(var2_2 - var6_6), (int)(var1_1 - var6_6)) && var5_5[1] <= var3_3)
        }
lbl12:
        // 1 sources

        if (var1_1 >= var6_6 && var2_2 >= var6_6 && var5_5[1] <= var3_3) ** GOTO lbl16
        return false;
lbl-1000:
        // 1 sources

        {
            var5_5[0] = var5_5[0] + 1;
            ++var6_6;
lbl16:
            // 2 sources

            ** while (var1_1 >= var6_6 && var2_2 >= var6_6 && this.image.get((int)(var2_2 - var6_6), (int)(var1_1 - var6_6)) && var5_5[0] <= var3_3)
        }
lbl17:
        // 1 sources

        if (var5_5[0] > var3_3) {
            return false;
        }
        var7_7 = this.image.getHeight();
        var8_8 = this.image.getWidth();
        var6_6 = 1;
        while (var1_1 + var6_6 < var7_7 && var2_2 + var6_6 < var8_8 && this.image.get(var2_2 + var6_6, var1_1 + var6_6)) {
            var5_5[2] = var5_5[2] + 1;
            ++var6_6;
        }
        if (var1_1 + var6_6 < var7_7 && var2_2 + var6_6 < var8_8) ** GOTO lbl30
        return false;
lbl-1000:
        // 1 sources

        {
            var5_5[3] = var5_5[3] + 1;
            ++var6_6;
lbl30:
            // 2 sources

            ** while (var1_1 + var6_6 < var7_7 && var2_2 + var6_6 < var8_8 && !this.image.get((int)(var2_2 + var6_6), (int)(var1_1 + var6_6)) && var5_5[3] < var3_3)
        }
lbl31:
        // 1 sources

        if (var1_1 + var6_6 < var7_7 && var2_2 + var6_6 < var8_8 && var5_5[3] < var3_3) ** GOTO lbl35
        return false;
lbl-1000:
        // 1 sources

        {
            var5_5[4] = var5_5[4] + 1;
            ++var6_6;
lbl35:
            // 2 sources

            ** while (var1_1 + var6_6 < var7_7 && var2_2 + var6_6 < var8_8 && this.image.get((int)(var2_2 + var6_6), (int)(var1_1 + var6_6)) && var5_5[4] < var3_3)
        }
lbl36:
        // 1 sources

        if (var5_5[4] >= var3_3) {
            return false;
        }
        var9_9 = var5_5[0] + var5_5[1] + var5_5[2] + var5_5[3] + var5_5[4];
        return Math.abs(var9_9 - var4_4) < 2 * var4_4 && FinderPatternFinder.foundPatternCross(var5_5) != false;
    }

    /*
     * Unable to fully structure code
     */
    private float crossCheckVertical(int var1_1, int var2_2, int var3_3, int var4_4) {
        var5_5 = this.image;
        var6_6 = var5_5.getHeight();
        var7_7 = this.getCrossCheckStateCount();
        var8_8 = var1_1;
        while (var8_8 >= 0 && var5_5.get(var2_2, var8_8)) {
            var7_7[2] = var7_7[2] + 1;
            --var8_8;
        }
        if (var8_8 >= 0) ** GOTO lbl13
        return NaNf;
lbl-1000:
        // 1 sources

        {
            var7_7[1] = var7_7[1] + 1;
            --var8_8;
lbl13:
            // 2 sources

            ** while (var8_8 >= 0 && !var5_5.get((int)var2_2, (int)var8_8) && var7_7[1] <= var3_3)
        }
lbl14:
        // 1 sources

        if (var8_8 >= 0 && var7_7[1] <= var3_3) ** GOTO lbl18
        return NaNf;
lbl-1000:
        // 1 sources

        {
            var7_7[0] = var7_7[0] + 1;
            --var8_8;
lbl18:
            // 2 sources

            ** while (var8_8 >= 0 && var5_5.get((int)var2_2, (int)var8_8) && var7_7[0] <= var3_3)
        }
lbl19:
        // 1 sources

        if (var7_7[0] > var3_3) {
            return NaNf;
        }
        var8_8 = var1_1 + 1;
        while (var8_8 < var6_6 && var5_5.get(var2_2, var8_8)) {
            var7_7[2] = var7_7[2] + 1;
            ++var8_8;
        }
        if (var8_8 != var6_6) ** GOTO lbl30
        return NaNf;
lbl-1000:
        // 1 sources

        {
            var7_7[3] = var7_7[3] + 1;
            ++var8_8;
lbl30:
            // 2 sources

            ** while (var8_8 < var6_6 && !var5_5.get((int)var2_2, (int)var8_8) && var7_7[3] < var3_3)
        }
lbl31:
        // 1 sources

        if (var8_8 != var6_6 && var7_7[3] < var3_3) ** GOTO lbl35
        return NaNf;
lbl-1000:
        // 1 sources

        {
            var7_7[4] = var7_7[4] + 1;
            ++var8_8;
lbl35:
            // 2 sources

            ** while (var8_8 < var6_6 && var5_5.get((int)var2_2, (int)var8_8) && var7_7[4] < var3_3)
        }
lbl36:
        // 1 sources

        if (var7_7[4] >= var3_3) {
            return NaNf;
        }
        var9_9 = var7_7[0] + var7_7[1] + var7_7[2] + var7_7[3] + var7_7[4];
        if (5 * Math.abs(var9_9 - var4_4) >= 2 * var4_4) {
            return NaNf;
        }
        return FinderPatternFinder.foundPatternCross(var7_7) != false ? FinderPatternFinder.centerFromEnd(var7_7, var8_8) : NaNf;
    }

    /*
     * Unable to fully structure code
     */
    private float crossCheckHorizontal(int var1_1, int var2_2, int var3_3, int var4_4) {
        var5_5 = this.image;
        var6_6 = var5_5.getWidth();
        var7_7 = this.getCrossCheckStateCount();
        var8_8 = var1_1;
        while (var8_8 >= 0 && var5_5.get(var8_8, var2_2)) {
            var7_7[2] = var7_7[2] + 1;
            --var8_8;
        }
        if (var8_8 >= 0) ** GOTO lbl13
        return NaNf;
lbl-1000:
        // 1 sources

        {
            var7_7[1] = var7_7[1] + 1;
            --var8_8;
lbl13:
            // 2 sources

            ** while (var8_8 >= 0 && !var5_5.get((int)var8_8, (int)var2_2) && var7_7[1] <= var3_3)
        }
lbl14:
        // 1 sources

        if (var8_8 >= 0 && var7_7[1] <= var3_3) ** GOTO lbl18
        return NaNf;
lbl-1000:
        // 1 sources

        {
            var7_7[0] = var7_7[0] + 1;
            --var8_8;
lbl18:
            // 2 sources

            ** while (var8_8 >= 0 && var5_5.get((int)var8_8, (int)var2_2) && var7_7[0] <= var3_3)
        }
lbl19:
        // 1 sources

        if (var7_7[0] > var3_3) {
            return NaNf;
        }
        var8_8 = var1_1 + 1;
        while (var8_8 < var6_6 && var5_5.get(var8_8, var2_2)) {
            var7_7[2] = var7_7[2] + 1;
            ++var8_8;
        }
        if (var8_8 != var6_6) ** GOTO lbl30
        return NaNf;
lbl-1000:
        // 1 sources

        {
            var7_7[3] = var7_7[3] + 1;
            ++var8_8;
lbl30:
            // 2 sources

            ** while (var8_8 < var6_6 && !var5_5.get((int)var8_8, (int)var2_2) && var7_7[3] < var3_3)
        }
lbl31:
        // 1 sources

        if (var8_8 != var6_6 && var7_7[3] < var3_3) ** GOTO lbl35
        return NaNf;
lbl-1000:
        // 1 sources

        {
            var7_7[4] = var7_7[4] + 1;
            ++var8_8;
lbl35:
            // 2 sources

            ** while (var8_8 < var6_6 && var5_5.get((int)var8_8, (int)var2_2) && var7_7[4] < var3_3)
        }
lbl36:
        // 1 sources

        if (var7_7[4] >= var3_3) {
            return NaNf;
        }
        var9_9 = var7_7[0] + var7_7[1] + var7_7[2] + var7_7[3] + var7_7[4];
        if (5 * Math.abs(var9_9 - var4_4) >= var4_4) {
            return NaNf;
        }
        return FinderPatternFinder.foundPatternCross(var7_7) != false ? FinderPatternFinder.centerFromEnd(var7_7, var8_8) : NaNf;
    }

    protected final boolean handlePossibleCenter(int[] nArray, int n, int n2, boolean bl) {
        int n3 = nArray[0] + nArray[1] + nArray[2] + nArray[3] + nArray[4];
        float f2 = FinderPatternFinder.centerFromEnd(nArray, n2);
        float f3 = this.crossCheckVertical(n, (int)f2, nArray[2], n3);
        if (!(Float.isNaN(f3) || Float.isNaN(f2 = this.crossCheckHorizontal((int)f2, (int)f3, nArray[2], n3)) || bl && !this.crossCheckDiagonal((int)f3, (int)f2, nArray[2], n3))) {
            float f4 = (float)n3 / 7.0f;
            boolean bl2 = false;
            int n4 = 0;
            while (n4 < this.possibleCenters.size()) {
                FinderPattern finderPattern = (FinderPattern)this.possibleCenters.get(n4);
                if (finderPattern.aboutEquals(f4, f3, f2)) {
                    this.possibleCenters.set(n4, finderPattern.combineEstimate(f3, f2, f4));
                    bl2 = true;
                    break;
                }
                ++n4;
            }
            if (!bl2) {
                FinderPattern finderPattern = new FinderPattern(f2, f3, f4);
                this.possibleCenters.add(finderPattern);
                if (this.resultPointCallback != null) {
                    this.resultPointCallback.foundPossibleResultPoint(finderPattern);
                }
            }
            return true;
        }
        return false;
    }

    private int findRowSkip() {
        int n = this.possibleCenters.size();
        if (n <= 1) {
            return 0;
        }
        FinderPattern finderPattern = null;
        for (FinderPattern finderPattern2 : this.possibleCenters) {
            if (finderPattern2.getCount() < 2) continue;
            if (finderPattern == null) {
                finderPattern = finderPattern2;
                continue;
            }
            this.hasSkipped = true;
            return (int)(Math.abs(finderPattern.getX() - finderPattern2.getX()) - Math.abs(finderPattern.getY() - finderPattern2.getY())) / 2;
        }
        return 0;
    }

    private boolean haveMultiplyConfirmedCenters() {
        int n = 0;
        float f2 = 0.0f;
        int n2 = this.possibleCenters.size();
        for (FinderPattern finderPattern : this.possibleCenters) {
            if (finderPattern.getCount() < 2) continue;
            ++n;
            f2 += finderPattern.getEstimatedModuleSize();
        }
        if (n < 3) {
            return false;
        }
        float f3 = f2 / (float)n2;
        float f4 = 0.0f;
        for (FinderPattern finderPattern : this.possibleCenters) {
            f4 += Math.abs(finderPattern.getEstimatedModuleSize() - f3);
        }
        return f4 <= 0.05f * f2;
    }

    private FinderPattern[] selectBestPatterns() {
        float f2;
        int n = this.possibleCenters.size();
        if (n < 3) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (n > 3) {
            float f3;
            f2 = 0.0f;
            float f4 = 0.0f;
            for (FinderPattern finderPattern : this.possibleCenters) {
                f3 = finderPattern.getEstimatedModuleSize();
                f2 += f3;
                f4 += f3 * f3;
            }
            float f5 = f2 / (float)n;
            float f6 = (float)Math.sqrt(f4 / (float)n - f5 * f5);
            Collections.sort(this.possibleCenters, new FinderPatternFinder$FurthestFromAverageComparator(f5, null));
            f3 = Math.max(0.2f * f5, f6);
            int n2 = 0;
            while (n2 < this.possibleCenters.size() && this.possibleCenters.size() > 3) {
                FinderPattern finderPattern = (FinderPattern)this.possibleCenters.get(n2);
                if (Math.abs(finderPattern.getEstimatedModuleSize() - f5) > f3) {
                    this.possibleCenters.remove(n2);
                    --n2;
                }
                ++n2;
            }
        }
        if (this.possibleCenters.size() > 3) {
            f2 = 0.0f;
            for (FinderPattern finderPattern : this.possibleCenters) {
                f2 += finderPattern.getEstimatedModuleSize();
            }
            float f7 = f2 / (float)this.possibleCenters.size();
            Collections.sort(this.possibleCenters, new FinderPatternFinder$CenterComparator(f7, null));
            this.possibleCenters.subList(3, this.possibleCenters.size()).clear();
        }
        return new FinderPattern[]{(FinderPattern)this.possibleCenters.get(0), (FinderPattern)this.possibleCenters.get(1), (FinderPattern)this.possibleCenters.get(2)};
    }
}

