/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.edit;

import android.content.Context;
import android.graphics.Color;
import android.graphics.RectF;
import java.util.Locale;
import java.util.StringTokenizer;
import org.json.JSONException;
import org.json.JSONObject;
import oz.viewer.ui.edit.ACanvasMemoView;
import oz.viewer.ui.edit.AControllerObject;
import oz.viewer.ui.edit.AEditableBaseView;
import oz.viewer.ui.edit.AEditableUtil;
import oz.viewer.ui.edit.AMemoInfo;

public class AControllerMemo
extends AControllerObject {
    private ACanvasMemoView m_memoView;
    private AMemoInfo m_memoInfo;
    private float m_scaledFontsize;

    public AControllerMemo(Context context, JSONObject jSONObject, AEditableBaseView aEditableBaseView) {
        super(context, aEditableBaseView, 0);
        this.setMemoInfo(new AMemoInfo());
        this.parse(jSONObject);
    }

    public AControllerMemo(Context context, AEditableBaseView aEditableBaseView, AMemoInfo aMemoInfo) {
        super(context, aEditableBaseView, 0);
        this.setMemoInfo(aMemoInfo);
        this.createMemoInfo();
        this.getBaseView().setDirty();
        this.setScaledFontSize((float)this.getMemoInfo().getFontSize() * this.getBaseView().m_canvasW);
    }

    void setScaledFontSize(float f2) {
        this.m_scaledFontsize = f2;
    }

    public float getScaledFontSize() {
        return this.m_scaledFontsize;
    }

    private void setMemoView(ACanvasMemoView aCanvasMemoView) {
        this.m_memoView = aCanvasMemoView;
    }

    public ACanvasMemoView getMemoView() {
        return this.m_memoView;
    }

    private void createMemoInfo() {
        this.createMemoView(this.getMemoInfo());
    }

    private void createMemoView(AMemoInfo aMemoInfo) {
        this.setMemoView(new ACanvasMemoView(this.getContext(), this.getBaseView(), aMemoInfo, this));
    }

    private void setMemoInfo(AMemoInfo aMemoInfo) {
        this.m_memoInfo = aMemoInfo;
    }

    public AMemoInfo getMemoInfo() {
        return this.m_memoInfo;
    }

    public void setProperties(RectF rectF, AMemoInfo aMemoInfo) {
        this.setRect(rectF);
        this.setMemoInfo(aMemoInfo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(JSONObject jSONObject) {
        try {
            if (jSONObject == null) throw new Exception("not MemoType");
            if (!jSONObject.getString("type").equalsIgnoreCase("memo")) throw new Exception("not MemoType");
            String string = jSONObject.getString("rect");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                string2 = string2.toLowerCase();
                string2 = string2.trim();
                stringArray[n++] = string2;
            }
            if (stringArray.length != 4) {
                throw new Exception();
            }
            float f2 = Float.parseFloat(stringArray[0]);
            float f3 = Float.parseFloat(stringArray[1]);
            float f4 = Float.parseFloat(stringArray[2]);
            float f5 = Float.parseFloat(stringArray[3]);
            this.setRect(f2, f3, f4, f5);
            this.setScaledFontSize((float)jSONObject.getDouble("fontsize"));
            this.getMemoInfo().setLabelCaption(jSONObject.getString("text"));
            this.getMemoInfo().setFontStyle(jSONObject.getInt("fontstyle"));
            this.getMemoInfo().setParagraphVerticalAlign(jSONObject.getInt("valign"));
            this.getMemoInfo().setParagraphHorizontalAlign(jSONObject.getInt("halign"));
            int n2 = jSONObject.getInt("fontcolor");
            int n3 = n2 & 0xFF;
            int n4 = (n2 & 0xFF00) >> 8;
            int n5 = (n2 & 0xFF0000) >> 16;
            this.getMemoInfo().setFontColor(AEditableUtil.getConvert10to16(n3, n4, n5));
            int n6 = jSONObject.getInt("backcolor");
            n3 = n6 & 0xFF;
            n4 = (n6 & 0xFF00) >> 8;
            n5 = (n6 & 0xFF0000) >> 16;
            this.getMemoInfo().setFillColor(AEditableUtil.getConvert10to16(n3, n4, n5));
            this.getMemoInfo().setFillAhpha(jSONObject.getInt("backalpha"));
            this.getMemoInfo().setTransparent(jSONObject.getInt("transparent") != 0);
            this.createMemoInfo();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JSONObject serialize() {
        String string = "";
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("type", (Object)"memo");
            string = String.format(Locale.ENGLISH, "%f,%f,%f,%f", Float.valueOf((this.getRect().left - this.getBaseView().getDstRect().left) * this.getBaseView().m_canvasW), Float.valueOf((this.getRect().top - this.getBaseView().getDstRect().top) * this.getBaseView().m_canvasW), Float.valueOf((this.getRect().right - this.getBaseView().getDstRect().left) * this.getBaseView().m_canvasW), Float.valueOf((this.getRect().bottom - this.getBaseView().getDstRect().top) * this.getBaseView().m_canvasW));
            jSONObject.put("rect", (Object)string);
            jSONObject.put("text", (Object)this.getMemoInfo().getLabelCaption());
            jSONObject.put("fontsize", (Object)String.valueOf((float)this.getMemoInfo().getFontSize() * this.getBaseView().m_canvasW));
            jSONObject.put("fontstyle", (Object)String.valueOf(this.getMemoInfo().getFontStyle()));
            jSONObject.put("valign", (Object)String.valueOf(this.getMemoInfo().getParagraphVerticalAlign()));
            jSONObject.put("halign", (Object)String.valueOf(this.getMemoInfo().getParagraphHorizontalAlign()));
            int n = Color.parseColor((String)("#" + this.getMemoInfo().getFontColor()));
            int n2 = n & 0xFF;
            int n3 = (n & 0xFF00) >> 8;
            int n4 = (n & 0xFF0000) >> 16;
            jSONObject.put("fontcolor", Color.parseColor((String)("#" + AEditableUtil.getConvert10to16(n2, n3, n4))));
            n = Color.parseColor((String)("#" + this.getMemoInfo().getFillColor()));
            n2 = n & 0xFF;
            n3 = (n & 0xFF00) >> 8;
            n4 = (n & 0xFF0000) >> 16;
            jSONObject.put("backcolor", Color.parseColor((String)("#" + AEditableUtil.getConvert10to16(n2, n3, n4))));
            jSONObject.put("backalpha", (Object)String.valueOf(this.getMemoInfo().getFillAhpha()));
            jSONObject.put("transparent", (Object)String.valueOf(this.getMemoInfo().isTransparent() ? 1 : 0));
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }
}

