/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.edit;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.hardware.Camera;
import android.os.Build;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oz.main.OZStorage;
import oz.util.BeepManager;
import oz.util.OZButton;
import oz.util.camera.DefaultOZCamera;
import oz.util.camera.GingerbreadOZCamera;
import oz.util.camera.OZCamera;
import oz.viewer.ui.edit.AEditableBaseView;
import oz.viewer.ui.edit.AEditableCameraView$1;
import oz.viewer.ui.edit.AEditableCameraView$2;
import oz.viewer.ui.edit.AEditableCameraView$3;
import oz.viewer.ui.edit.AEditableCameraView$4;
import oz.viewer.ui.edit.AEditableFrameLayout;

public class AEditableCameraView
extends AEditableFrameLayout
implements SurfaceHolder.Callback {
    SurfaceView mSurfaceView;
    SurfaceHolder mHolder;
    Camera.Size mPreviewSize;
    Camera.Size mPictureSize;
    List mSupportedPreviewSizes;
    Camera mCamera;
    int m_width;
    int m_height;
    public int m_rotationResult = 0;
    public float scaledChildWidth;
    public float scaledChildHeight;
    public float posLeft;
    public float posTop;
    public float flagLayout = 0.0f;
    public float pictureRatioW;
    public float pictureRatioH = 1.0f;
    public int previewWidth;
    public int previewHeight;
    public int pictureWidth;
    public int pictureHeight;
    Camera.CameraInfo mCameraInfo;
    int dpi = 96;
    int m_left;
    int m_top;
    int m_right;
    int m_bottom;
    int m_facingMode;
    float m_bmpWidth;
    float m_bmpHeight;
    private final int MODE_SHOOT = 1001;
    private final int MODE_RESHOOT = 1002;
    private int m_mode = 1001;
    Bitmap m_bitmap;
    protected BeepManager m_beepManager;
    Camera.Parameters parameters;
    boolean isFirst = true;
    public Camera.PictureCallback mPictureListener = new AEditableCameraView$3(this);

    public AEditableCameraView(Context context, AEditableBaseView aEditableBaseView) {
        super(context, aEditableBaseView);
        this.createCamera();
        this.mSurfaceView = new SurfaceView(context);
        this.mSurfaceView.bringToFront();
        this.addView((View)this.mSurfaceView);
        this.mSupportedPreviewSizes = this.mCamera.getParameters().getSupportedPreviewSizes();
        this.checkSupportedPictureSizeAtPreviewSize(this.mSupportedPreviewSizes);
        this.requestLayout();
        this.mHolder = this.mSurfaceView.getHolder();
        this.mHolder.addCallback((SurfaceHolder.Callback)this);
        this.mHolder.setType(3);
        this.setBackgroundColor(-256);
        this.addBtnLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCamera() {
        this.mCameraInfo = null;
        try {
            OZCamera oZCamera;
            OZCamera oZCamera2 = null;
            oZCamera2 = Build.VERSION.SDK_INT < 9 ? (oZCamera = new DefaultOZCamera()) : (oZCamera = new GingerbreadOZCamera());
            boolean bl = true;
            bl = this.m_facingMode == 0;
            this.mCamera = oZCamera2.open(bl);
            this.mCameraInfo = oZCamera2.getCameraInfo();
            int n = ((Activity)this.getContext()).getWindowManager().getDefaultDisplay().getRotation();
            int n2 = 0;
            switch (n) {
                case 0: {
                    n2 = 0;
                    break;
                }
                case 1: {
                    n2 = 90;
                    break;
                }
                case 2: {
                    n2 = 180;
                    break;
                }
                case 3: {
                    n2 = 270;
                }
            }
            int n3 = 0;
            if (this.mCameraInfo != null) {
                n3 = this.mCameraInfo.orientation;
            } else if (!this.isLandscapeTop(this.getContext())) {
                n3 = 90;
            }
            if (this.mCameraInfo != null && this.mCameraInfo.facing == 1) {
                this.m_rotationResult = (n3 + n2) % 360;
                this.m_rotationResult = (360 - this.m_rotationResult) % 360;
            } else {
                this.m_rotationResult = (n3 - n2 + 360) % 360;
            }
            this.m_beepManager = new BeepManager((Activity)this.getContext());
        }
        catch (Throwable throwable) {
            Log.d((String)"OZViewer", (String)"Camera open retry.");
            try {
                try {
                    Thread.sleep(100L);
                    this.mCamera = Camera.open();
                }
                catch (Throwable throwable2) {
                    Log.d((String)"OZViewer", (String)("Camera open error:" + throwable.getLocalizedMessage()), (Throwable)throwable);
                    this.mCamera = null;
                    Object var7_10 = null;
                    this.mCameraInfo = null;
                }
                Object var7_9 = null;
                this.mCameraInfo = null;
            }
            catch (Throwable throwable3) {
                Object var7_11 = null;
                this.mCameraInfo = null;
                throw throwable3;
            }
        }
    }

    private void addBtnLayout() {
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        this.m_left = n;
        this.m_top = n2;
        this.m_right = n3;
        this.m_bottom = n4;
        if (bl && this.getChildCount() > 0) {
            View view = this.getChildAt(0);
            float f2 = n3 - n;
            float f3 = n4 - n2;
            this.previewWidth = (int)f2;
            this.previewHeight = (int)f3;
            if (this.mSupportedPreviewSizes != null && this.mPreviewSize == null) {
                this.mPreviewSize = this.getOptimalPreviewSize(this.mSupportedPreviewSizes);
            }
            if (this.mPreviewSize != null) {
                if (this.previewWidth < this.previewHeight) {
                    this.previewWidth = this.mPreviewSize.height;
                    this.previewHeight = this.mPreviewSize.width;
                } else {
                    this.previewWidth = this.mPreviewSize.width;
                    this.previewHeight = this.mPreviewSize.height;
                }
            }
            if (f2 * (float)this.previewHeight > f3 * (float)this.previewWidth) {
                this.scaledChildWidth = f2;
                this.scaledChildHeight = (float)this.previewHeight * f2 / (float)this.previewWidth;
            } else {
                this.scaledChildWidth = (float)this.previewWidth * f3 / (float)this.previewHeight;
                this.scaledChildHeight = f3;
            }
            view.layout(0, 0, (int)this.scaledChildWidth, (int)this.scaledChildHeight);
            this.setMeasuredDimension((int)this.scaledChildWidth, (int)this.scaledChildHeight);
        }
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        try {
            if (this.mCamera != null) {
                this.mCamera.setPreviewDisplay(surfaceHolder);
            }
        }
        catch (IOException iOException) {
            Log.e((String)"OZViewer", (String)"IOException caused by setPreviewDisplay()", (Throwable)iOException);
        }
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        if (this.mCamera != null) {
            this.mCamera.stopPreview();
        }
    }

    private Camera.Size getOptimalPreviewSizeDefault(List list) {
        Camera.Size size = null;
        int n = OZStorage.m_screenHeight;
        int n2 = OZStorage.m_screenWidth;
        if (n > n2) {
            int n3 = n2;
            n2 = n;
            n = n3;
        }
        float f2 = (float)n2 / (float)n;
        List list2 = this.parameters == null ? this.mCamera.getParameters().getSupportedPictureSizes() : this.parameters.getSupportedPictureSizes();
        float[] fArray = new float[list.size()];
        int[] nArray = new int[list.size()];
        int[] nArray2 = new int[list.size()];
        int n4 = 0;
        int n5 = 0;
        for (int j = 0; j < list.size(); ++j) {
            fArray[n4] = (float)((Camera.Size)list.get((int)j)).width / (float)((Camera.Size)list.get((int)j)).height;
            boolean bl = false;
            for (int k = 0; k < n4; ++k) {
                if (!(Math.abs(fArray[k] - fArray[n4]) < 0.01f)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            nArray[n4] = (int)(Math.abs(f2 - fArray[n4]) < 0.2f ? (float)this.findSameRatioSize(list2, fArray[n4]).size() * 1.5f : (float)this.findSameRatioSize(list2, fArray[n4]).size());
            nArray2[n4] = j;
            if (nArray[n4] > nArray[n5]) {
                n5 = n4;
            }
            ++n4;
        }
        size = (Camera.Size)list.get(nArray2[n5]);
        return size;
    }

    private void checkSupportedPictureSizeAtPreviewSize(List list) {
        List list2 = this.mCamera.getParameters().getSupportedPreviewSizes();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.05;
        boolean bl = false;
        for (int j = list.size() - 1; j >= 0; --j) {
            Camera.Size size = (Camera.Size)list.get(j);
            d2 = (double)size.width / (double)size.height;
            bl = false;
            for (int k = list2.size() - 1; k >= 0; --k) {
                Camera.Size size2 = (Camera.Size)list2.get(k);
                d3 = (double)size2.width / (double)size2.height;
                if (!(Math.abs(d2 - d3) < 0.05)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            list.remove(j);
            Log.e((String)"OZViewer", (String)("remove picture size : " + size.width + ", " + size.height));
        }
    }

    private Camera.Size getOptimalPreviewSize(List list) {
        return this.getOptimalPreviewSizeDefault(list);
    }

    public boolean isLandscapeTop(Context context) {
        boolean bl;
        int n;
        if (OZStorage.DEVICE_CAMERA_POSITION_PRIORITY != null && (n = OZStorage.DEVICE_CAMERA_POSITION_PRIORITY.size()) > 0) {
            for (String string : OZStorage.DEVICE_CAMERA_POSITION_PRIORITY.keySet()) {
                if (!Build.DEVICE.equalsIgnoreCase(string) && !Build.MODEL.equalsIgnoreCase(string)) continue;
                boolean bl2 = OZStorage.CAMERA_POSITION_LANDSCAPE_TOP == (Integer)OZStorage.DEVICE_CAMERA_POSITION_PRIORITY.get(string);
                return bl2;
            }
        }
        n = (context.getResources().getConfiguration().screenLayout & 0xF) == 4 ? 1 : 0;
        boolean bl3 = bl = (context.getResources().getConfiguration().screenLayout & 0xF) == 3;
        if (Build.DEVICE.toUpperCase().startsWith("SHW-M180") || Build.MODEL.toUpperCase().startsWith("SHW-M180") || Build.DEVICE.toUpperCase().startsWith("SHW-M500") || Build.MODEL.toUpperCase().startsWith("SHW-M500") || Build.DEVICE.toUpperCase().startsWith("NEXUS 7") || Build.MODEL.toUpperCase().startsWith("NEXUS 7") || Build.DEVICE.toUpperCase().startsWith("NEXUS 9") || Build.MODEL.toUpperCase().startsWith("NEXUS 9") || Build.DEVICE.toUpperCase().startsWith("SM-T330") || Build.MODEL.toUpperCase().startsWith("SM-T330") || Build.DEVICE.toUpperCase().startsWith("SM-T330K") || Build.MODEL.toUpperCase().startsWith("SM-T330K") || Build.DEVICE.toUpperCase().startsWith("SM-T330L") || Build.MODEL.toUpperCase().startsWith("SM-T330L") || Build.DEVICE.toUpperCase().startsWith("SM-T550") || Build.MODEL.toUpperCase().startsWith("SM-T550") || Build.DEVICE.toUpperCase().startsWith("SM-P550") || Build.MODEL.toUpperCase().startsWith("SM-P550") || Build.DEVICE.toUpperCase().startsWith("SM-P555") || Build.MODEL.toUpperCase().startsWith("SM-P555") || Build.DEVICE.toUpperCase().startsWith("SM-T700") || Build.MODEL.toUpperCase().startsWith("SM-T700") || Build.DEVICE.toUpperCase().startsWith("SM-T705") || Build.MODEL.toUpperCase().startsWith("SM-T705")) {
            return false;
        }
        return n != 0 || bl;
    }

    private List findSameRatioSize(List list, float f2) {
        ArrayList arrayList = new ArrayList();
        for (int j = 0; j < list.size(); ++j) {
            if (!(Math.abs(f2 - (float)((Camera.Size)list.get((int)j)).width / (float)((Camera.Size)list.get((int)j)).height) < 0.01f)) continue;
            arrayList.add(list.get(j));
        }
        return arrayList;
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        if (this.mCamera != null) {
            this.parameters = this.mCamera.getParameters();
            int n4 = ((Activity)this.getContext()).getWindowManager().getDefaultDisplay().getRotation();
            int n5 = 0;
            switch (n4) {
                case 0: {
                    n5 = 0;
                    break;
                }
                case 1: {
                    n5 = 90;
                    break;
                }
                case 2: {
                    n5 = 180;
                    break;
                }
                case 3: {
                    n5 = 270;
                }
            }
            int n6 = 0;
            if (this.mCameraInfo != null) {
                n6 = this.mCameraInfo.orientation;
            } else if (!this.isLandscapeTop(this.getContext())) {
                n6 = 90;
            }
            if (this.mCameraInfo != null && this.mCameraInfo.facing == 1) {
                this.m_rotationResult = (n6 + n5) % 360;
                this.m_rotationResult = (360 - this.m_rotationResult) % 360;
            } else {
                this.m_rotationResult = (n6 - n5 + 360) % 360;
            }
            this.mCamera.setDisplayOrientation(this.m_rotationResult);
            if (this.mPreviewSize == null) {
                this.mPreviewSize = this.getOptimalPreviewSize(this.mSupportedPreviewSizes);
            }
            Camera.Size size = null;
            List list = this.mCamera.getParameters().getSupportedPictureSizes();
            this.checkSupportedPictureSizeAtPreviewSize(list);
            list = this.bubble_sort(list, list.size());
            int n7 = 921600;
            for (int j = list.size() - 1; j >= 0; --j) {
                int n8 = ((Camera.Size)list.get((int)j)).width;
                int n9 = ((Camera.Size)list.get((int)j)).height;
                if (n8 * n9 < n7) continue;
                size = (Camera.Size)list.get(j);
                break;
            }
            if (size == null) {
                size = (Camera.Size)list.get(0);
            }
            this.mPictureSize = size;
            this.parameters.setPictureSize(this.mPictureSize.width, this.mPictureSize.height);
            this.parameters.setPreviewSize(this.mPreviewSize.width, this.mPreviewSize.height);
            String string = this.findSettableValue(this.parameters.getSupportedFocusModes(), "auto");
            if (string != null) {
                this.parameters.setFocusMode(string);
            }
            this.doSetTorch(this.parameters, 2);
            Log.d((String)"OZViewer", (String)("selectPreviewSize(" + this.mPreviewSize.width + "," + this.mPreviewSize.height + ") selectPictureSize(" + size.width + "," + size.height + ")"));
            this.requestLayout();
            this.pictureWidth = size.width;
            this.pictureHeight = size.height;
            this.pictureRatioW = (float)size.width / (float)this.mPreviewSize.width;
            this.pictureRatioH = (float)size.height / (float)this.mPreviewSize.height;
            this.mCamera.setParameters(this.parameters);
            this.startCameraPreview();
        }
    }

    private void doSetTorch(Camera.Parameters parameters, int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = this.findSettableValue(parameters.getSupportedFlashModes(), "off");
                break;
            }
            case 1: {
                string = this.findSettableValue(parameters.getSupportedFlashModes(), "on");
                break;
            }
            case 2: {
                string = this.findSettableValue(parameters.getSupportedFlashModes(), "auto");
            }
        }
        if (string != null) {
            parameters.setFlashMode(string);
        }
    }

    private String findSettableValue(Collection collection, String ... stringArray) {
        Log.i((String)"OZViewer", (String)("Supported values: " + collection));
        String string = null;
        if (collection != null) {
            for (String string2 : stringArray) {
                if (!collection.contains(string2)) continue;
                string = string2;
                break;
            }
        }
        Log.i((String)"OZViewer", (String)("Settable value: " + string));
        return string;
    }

    private boolean minSize(Camera.Size size, Camera.Size size2) {
        if (size.width < size2.width) {
            return true;
        }
        if (size.width == size2.width) {
            return size.height < size2.height;
        }
        return false;
    }

    private List bubble_sort(List list, int n) {
        for (int j = 0; j < n; ++j) {
            for (int k = 1; k < n - j; ++k) {
                if (!this.minSize((Camera.Size)list.get(k - 1), (Camera.Size)list.get(k))) continue;
                Camera.Size size = (Camera.Size)list.get(k - 1);
                list.set(k - 1, list.get(k));
                list.set(k, size);
            }
        }
        return list;
    }

    protected Rect computeAllSize(Camera.Size size, Camera.Size size2) {
        float f2 = 600.0f;
        float f3 = 450.0f;
        float f4 = size.width;
        float f5 = size.height;
        float f6 = size2.width;
        float f7 = size2.height;
        if (this.m_rotationResult == 90 || this.m_rotationResult == 270) {
            f4 = size.height;
            f5 = size.width;
            f6 = size2.height;
            f7 = size2.width;
        }
        float f8 = Math.min(f4 / f6, f5 / f7);
        float f9 = f6 * f8;
        float f10 = f7 * f8;
        float f11 = f4 - f9;
        float f12 = f5 - f10;
        boolean bl = true;
        boolean bl2 = true;
        float f13 = 500.0f;
        float f14 = 300.0f;
        float f15 = Math.min(f13, f14);
        float f16 = bl ? f4 : f2 * f15;
        float f17 = bl2 ? f5 : f3 * f15;
        f16 -= f11 / 2.0f;
        f17 -= f12 / 2.0f;
        float f18 = f11 / 2.0f;
        float f19 = f12 / 2.0f;
        if (!bl) {
            // empty if block
        }
        if (!bl2) {
            // empty if block
        }
        if (f18 < 0.0f) {
            f16 += f18;
            f18 = 0.0f;
        }
        if (f19 < 0.0f) {
            f17 += f19;
            f19 = 0.0f;
        }
        int n = (int)f18;
        int n2 = (int)f19;
        int n3 = (int)f16;
        int n4 = (int)f17;
        if (n + n3 > (int)f4) {
            n3 = (int)f4 - n;
        }
        if (n2 + n4 > (int)f5) {
            n4 = (int)f5 - n2;
        }
        return new Rect(n, n2, n + n3, n2 + n4);
    }

    public void startCameraPreview() {
        if (this.mCamera == null) {
            return;
        }
        if (this.mCamera != null) {
            this.startPreview(this.mCamera);
        }
    }

    protected void startPreview(Camera camera) {
        try {
            camera.startPreview();
        }
        catch (Throwable throwable) {
            Log.d((String)"OZViewer", (String)("Camera is start preview error. one more retry :" + throwable.getLocalizedMessage()));
            try {
                camera.startPreview();
            }
            catch (Throwable throwable2) {
                Log.e((String)"OZViewer", (String)("Camera is start preview error : :" + throwable.getLocalizedMessage()));
            }
        }
    }

    public void removeAllObject() {
        if (this.mSurfaceView != null) {
            this.removeView((View)this.mSurfaceView);
        }
        this.mSurfaceView = null;
        this.mHolder = null;
        this.mPreviewSize = null;
        this.mSupportedPreviewSizes = null;
        if (this.mCamera != null) {
            this.mCamera.release();
        }
        this.mCamera = null;
    }

    public void setShooBtnOnClickListener(OZButton oZButton) {
        oZButton.setOnClickListener(new AEditableCameraView$1(this));
    }

    public void setConfirmBtnOnClickListener(OZButton oZButton, Dialog dialog) {
        oZButton.setOnClickListener(new AEditableCameraView$2(this, dialog));
    }

    private void stopPreview() {
        if (this.mCamera != null) {
            this.mCamera.stopPreview();
        }
    }

    private void computeAllSize() {
        if (this.m_rotationResult == 90 || this.m_rotationResult == 270) {
            this.m_bmpWidth = this.mPictureSize.height;
            this.m_bmpHeight = this.mPictureSize.width;
        } else {
            this.m_bmpWidth = this.mPictureSize.width;
            this.m_bmpHeight = this.mPictureSize.height;
        }
    }

    private void postCameraPicture() {
        this.post(new AEditableCameraView$4(this));
    }

    static /* synthetic */ int access$000(AEditableCameraView aEditableCameraView) {
        return aEditableCameraView.m_mode;
    }

    static /* synthetic */ int access$002(AEditableCameraView aEditableCameraView, int n) {
        aEditableCameraView.m_mode = n;
        return aEditableCameraView.m_mode;
    }

    static /* synthetic */ void access$100(AEditableCameraView aEditableCameraView) {
        aEditableCameraView.stopPreview();
    }

    static /* synthetic */ void access$200(AEditableCameraView aEditableCameraView) {
        aEditableCameraView.computeAllSize();
    }

    static /* synthetic */ void access$300(AEditableCameraView aEditableCameraView) {
        aEditableCameraView.postCameraPicture();
    }
}

