/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.main.overlay;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.util.Hashtable;
import oz.resource.OZAndroidResource;
import oz.viewer.ui.edit.AEditableBaseView;
import oz.viewer.ui.edit.AEditableBottomBar;
import oz.viewer.ui.main.overlay.ACommentManager$1;
import oz.viewer.ui.main.overlay.ACommentManager$BaseViewConnector;
import oz.viewer.ui.main.overlay.AutoHideAbleOZOverlayView;
import oz.viewer.ui.main.overlay.OverlayLayout;

public class ACommentManager
extends AutoHideAbleOZOverlayView {
    public static final int PEN = 0;
    public static final int HPEN = 1;
    public static final int ERASER = 2;
    public static final int SELECT_COMP_STROKE = 3;
    public static final int SELECT_COMP_FILL = 4;
    public static final int ERASERALL = 101;
    public static final int THICK = 102;
    public static final int COLOR = 103;
    public static final int ADDMEMO = 104;
    public static final int ADDIMAGE = 105;
    public static final int OPENBTN = 106;
    public static final int REQ_OZ_EDITABLEMODE_TAKE_IMAGE = 13004;
    public static final int REQ_OZ_EDITABLEMODE_PICK_IMAGE = 13005;
    private AEditableBaseView m_baseView;
    private ACommentManager$BaseViewConnector mConnector;
    private AEditableBottomBar mView;
    private Hashtable mIsButtonVisible;

    public ACommentManager(OverlayLayout overlayLayout) {
        super(overlayLayout, 2);
        int n;
        this.setHideVisibility(8);
        this.mIsButtonVisible = new Hashtable();
        for (n = 0; n <= 4; ++n) {
            this.mIsButtonVisible.put(n, true);
        }
        for (n = 101; n <= 106; ++n) {
            this.mIsButtonVisible.put(n, true);
        }
        this.mConnector = new ACommentManager$BaseViewConnector(this);
        this.m_baseView = new AEditableBaseView(this.getContext());
        this.getBaseView().setBottomBar(new AEditableBottomBar(this.getContext(), this.m_baseView, false, this.mConnector, this.getOZParent().getMainFrameView()));
        this.mView = this.getBaseView().getBottomBar();
        this.mView.setVisibility(8);
        this.requestNeedUpdateView();
    }

    protected View getView() {
        return this.mView;
    }

    protected void addToOverlayView(OverlayLayout overlayLayout, View view) {
        ViewGroup viewGroup = (ViewGroup)overlayLayout.findLayout(22000);
        viewGroup.addView(view, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 81));
    }

    public void clearComment() {
        this.getNativeController().commentClear();
    }

    public boolean isButtonVisible(int n) {
        Boolean bl = (Boolean)this.mIsButtonVisible.get(n);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public void setButtonVisible(int n, boolean bl) {
        if (this.isButtonVisible(n) != bl) {
            this.mIsButtonVisible.put(n, bl);
            this.requestNeedUpdateView();
        }
    }

    public boolean isClearNeedConfirm() {
        return this.getNativeController().isCommentClearNeedConfirm();
    }

    public void openImage(Bitmap bitmap) {
        this.getBaseView().showEditableImageView(bitmap);
    }

    public void show() {
        super.show();
    }

    public AEditableBaseView getBaseView() {
        return this.m_baseView;
    }

    public void selectCommentToolMode(int n, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = bl && n == this.getBaseView().getCommentMode() && (n == 0 || n == 1 || n == 4 || n == 3);
        if (bl2 && (this.getOZParent().getScreenToolController().isCommentNormalMode() || this.getOZParent().getScreenToolController().isCommentFillMode())) {
            if (this.getBaseView().getCommentPenSelectDialog() != null && this.getBaseView().getCommentPenSelectDialog().isShowing()) {
                this.getBaseView().getCommentPenSelectDialog().dismiss();
            }
            this.getBaseView().showCommentToolWnd();
        } else {
            this.getNativeController().commentSetSelectedPen(n);
            this.getBaseView().setCommentModeChange(n);
            this.getBaseView().getBottomBar().setCommentMode();
            this.getBaseView().getBottomBar().setModeBackground();
        }
    }

    public void clearComment(boolean bl) {
        if (bl) {
            new AlertDialog.Builder(this.getContext()).setIcon(17301543).setTitle((CharSequence)OZAndroidResource.getResource(60014)).setMessage((CharSequence)OZAndroidResource.getResource("comment.clear.msg")).setPositiveButton((CharSequence)OZAndroidResource.getResource(61090), (DialogInterface.OnClickListener)new ACommentManager$1(this)).setNegativeButton((CharSequence)OZAndroidResource.getResource(61091), null).show();
        } else {
            this.clearComment();
        }
    }

    public void selectPen(int n) {
        if (this.getBaseView() != null) {
            this.getBaseView().setCommentMode(n);
        }
    }

    public void setPenThick(int n, int n2) {
        if (this.getBaseView() != null) {
            this.getBaseView().setPenThick(n, n2);
        }
    }

    public void setPenColor(int n, int n2) {
        if (this.getBaseView() != null) {
            int n3 = Color.blue((int)n2);
            int n4 = Color.green((int)n2);
            int n5 = Color.red((int)n2);
            this.getBaseView().setPenColor(n, Color.rgb((int)n3, (int)n4, (int)n5));
        }
    }
}

