package jp.agentec.abook.abv.bl.acms.client.json;

import jp.agentec.abook.abv.bl.acms.client.AcmsClient;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;

import org.json.adf.JSONException;
import org.json.adf.JSONObject;

/**
 * {@link AcmsClient#appLatestVersion} の戻り値です。
 * FIXME later デプロイ方式を決めた上、APIを変更する必要有り。
 * @author Taejin Hong
 * @version 1.0.0
 */
public class AppLatestVersionJSON extends AcmsCommonJSON {
	public static final String AppLatestVersion = "appLatestVersion";
	
	public String appLatestVersion; // アプリの最新バージョン番号
	
	public AppLatestVersionJSON(String jsonString) throws AcmsException {
		super(jsonString);
	}
	
	@Override
	protected void parse(JSONObject json) throws JSONException, JSONValidationException {
		super.parse(json);
		appLatestVersion = getString(json, AppLatestVersion, null);
	}
}
