package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

import java.util.ArrayList;

import jp.agentec.abook.abv.bl.common.constant.ABookCommConstants;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;
import jp.agentec.abook.abv.bl.dto.ArchiveDto;
import jp.agentec.adf.util.DateTimeUtil;

public class ArchiveDetailJSON extends AcmsCommonJSON {

    public ArchiveDto archiveDto;
    public ArchiveDetailJSON(String jsonString) throws AcmsException {
        super(jsonString);
    }

    @Override
    protected void parse(JSONObject json) throws JSONValidationException {

        // ルーム一覧情報を取得
        if (!json.has(ABookCommConstants.KEY.BODY)) { return; }
        if (!json.getJSONObject(ABookCommConstants.KEY.BODY).has(ABookCommConstants.KEY.ARCHIVE_INFO)) { return; }

        JSONObject archiveInfo = json.getJSONObject(ABookCommConstants.KEY.BODY).getJSONObject(ABookCommConstants.KEY.ARCHIVE_INFO);
        archiveDto = new ArchiveDto();
        archiveDto.archiveId = archiveInfo.getInt(ABookCommConstants.KEY.ARCHIVE_ID);
        archiveDto.archiveName = archiveInfo.getString(ABookCommConstants.KEY.ARCHIVE_NAME);
        archiveDto.archiveType = archiveInfo.getInt(ABookCommConstants.KEY.ARCHIVE_TYPE);
        archiveDto.archiveDate = DateTimeUtil.millToDateString(archiveInfo.getJSONObject(ABookCommConstants.KEY.ARCHIVE_DATE)
                .getLong(ABookCommConstants.KEY.TIME), "yyyy/MM/dd HH:mm");
        archiveDto.roomId = archiveInfo.getInt(ABookCommConstants.KEY.ROOM_ID);
        archiveDto.roomName = archiveInfo.getString(ABookCommConstants.KEY.ROOM_NAME);
        archiveDto.saveUserId = archiveInfo.getInt(ABookCommConstants.KEY.SAVE_USER_ID);
        archiveDto.filePath = archiveInfo.getString(ABookCommConstants.KEY.FILE_PATH);
        if (archiveInfo.has(ABookCommConstants.KEY.ATTEND_USER_IDS)) {
            archiveDto.attendUserIds = archiveInfo.getJSONArray(ABookCommConstants.KEY.ATTEND_USER_IDS).toString();
        }

    }
}

