package jp.agentec.abook.abv.bl.acms.client.json;

import java.util.ArrayList;

import jp.agentec.abook.abv.bl.acms.client.AcmsClient;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;
import jp.agentec.abook.abv.bl.common.util.JsonUtil;
import jp.agentec.abook.abv.bl.dto.ContentDto;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

/**
 * {@link AcmsClient#contentVersion} の戻り値です。
 * @author Taejin Hong
 * @version 1.0.0
 */
public class ContentVersionsJSON extends AcmsCommonJSON {
	public static final String ContentList = "contentList";
	public static final String ContentId = "contentId";
	public static final String MetaVersion = "metaVersion";
	public static final String ResourceVersion = "resourceVersion";
	public static final String ContentNameKana = "contentNameKana";
	public static final String ContentType = "contentType";
    public static final String FetchDate = "fetchDate";
	
	public ArrayList<ContentDto> contentVersions;
    public String fetchDate;

	public static final String ResourcePatternType = "resourcePatternType"; // 文言リソースパターン
	public int resourcePatternType;  // 文言リソースパターン変数

	public ContentVersionsJSON(String jsonString) throws AcmsException {
		super(jsonString);
	}
	
	@Override
	protected void parse(JSONObject json) throws JSONValidationException {
		// 取得したJSONから事業者リソースパターンを取得する
		if (json.has(ResourcePatternType)) {
			resourcePatternType = json.getInt(ResourcePatternType);
		}
		if (json.has(FetchDate)) {
            fetchDate = json.getString(FetchDate);
        }
		if (json.has(ContentList)) {
			JSONArray jarr = json.getJSONArray(ContentList);
			
			int count = jarr.length();
			contentVersions = new ArrayList<ContentDto>();
			
			for (int i = 0; i < count; i++) {
				JSONObject version = jarr.getJSONObject(i);
				long contentId = getLong(version, ContentId);
				int metaVersion = getInt(version, MetaVersion);
				int resourceVersion = getInt(version, ResourceVersion);
				String contentNameKana = getString(version, ContentNameKana, null);
				int contentType = getInt(version, ContentType, 0);
				
				contentVersions.add(new ContentDto(contentId, metaVersion, resourceVersion, contentNameKana, contentType));
			}
		} else {
			throw new JSONValidationException(json.toString(), ContentList + " property not found.");
		}
	}
}
