package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.constant.ABookCommConstants;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;
import jp.agentec.abook.abv.bl.dto.ShopMemberDto;

public class GetFavoriteUserJSON extends AcmsCommonJSON {

    public List<Integer> favoriteUserIds;

    public GetFavoriteUserJSON(String jsonString) throws AcmsException {
        super(jsonString);
    }

    @Override
    protected void parse(JSONObject json) throws JSONValidationException {
        favoriteUserIds = new ArrayList<Integer>();
        if (!json.has(ABookCommConstants.KEY.BODY)) { return; }

        JSONObject responseBodyObject = json.getJSONObject(ABookCommConstants.KEY.BODY);
        if (responseBodyObject == null) { return; }
        JSONArray favoriteIds = responseBodyObject.getJSONArray(ABookCommConstants.KEY.FAVORITE_USER_IDS);

        if (favoriteIds == null || favoriteIds.length() == 0) {
            return;
        }

        for (int count = 0; count < favoriteIds.length(); count++) {
            favoriteUserIds.add((Integer)favoriteIds.get(count));
        }
    }
}

