package jp.agentec.abook.abv.bl.acms.client.json;

import jp.agentec.abook.abv.bl.websocket.MeetingManager;

import org.json.adf.JSONException;
import org.json.adf.JSONObject;

public class MarkingJson {
	public int drawAction;
	public int mode;
	public int width;
	public int alpha;
	public int red;
	public int green;
	public int blue;
	public float pointX;
	public float pointY;

	public MarkingJson(JSONObject json, float scale) {
		parse(json, scale);
	}

	private void parse(JSONObject json, float scale) throws JSONException {
		drawAction = json.getInt(MeetingManager.MARKING_DRAW_ACTION);

		if (drawAction == 0) {
			mode = json.getInt(MeetingManager.MARKING_DRAW_MODE);
			width = (int) (json.getInt(MeetingManager.MARKING_DRAW_WIDTH) * scale);
			alpha = json.getInt(MeetingManager.MARKING_DRAW_ALPHA);
			red = json.getInt(MeetingManager.MARKING_DRAW_RED);
			green = json.getInt(MeetingManager.MARKING_DRAW_GREEN);
			blue = json.getInt(MeetingManager.MARKING_DRAW_BLUE);
		}
		
		if (drawAction != 1) {
			pointX = json.getInt(MeetingManager.X) * scale;
			pointY = json.getInt(MeetingManager.Y) * scale;
		}
	}
}
