package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

import java.util.ArrayList;

import jp.agentec.abook.abv.bl.common.constant.ABookCommConstants;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;
import jp.agentec.abook.abv.bl.dto.ChatMessageDto;
import jp.agentec.abook.abv.bl.dto.ChatRoomDto;
import jp.agentec.adf.util.DateTimeUtil;

public class RoomJSON extends AcmsCommonJSON {


    public ChatRoomDto chatRoomDto;

    public RoomJSON(String jsonString) throws AcmsException {
        super(jsonString);
    }

    @Override
    protected void parse(JSONObject json) throws JSONValidationException {

        // ルーム一覧情報を取得
        if (!json.has(ABookCommConstants.KEY.BODY)) { return; }

        JSONObject roomInfo = json.getJSONObject(ABookCommConstants.KEY.BODY);

        chatRoomDto = new ChatRoomDto();
        chatRoomDto.chatRoomId = roomInfo.getInt(ABookCommConstants.KEY.ROOM_ID);
        chatRoomDto.chatRoomName = roomInfo.getString(ABookCommConstants.KEY.ROOM_NAME);
        chatRoomDto.type = roomInfo.getInt(ABookCommConstants.KEY.ROOM_TYPE);
        chatRoomDto.userCount = roomInfo.getJSONArray(ABookCommConstants.KEY.ATTEND_USER_IDS).length();
        JSONArray attendUsers = roomInfo.getJSONArray(ABookCommConstants.KEY.ATTEND_USER_IDS);
        ArrayList<Integer> attendUserList = new ArrayList<Integer>();
        for (int attendUserCount = 0; attendUserCount < attendUsers.length(); attendUserCount++) {
            attendUserList.add((Integer) attendUsers.get(attendUserCount));
        }
        chatRoomDto.attendUsers = attendUserList;
    }
}

