package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

import java.util.ArrayList;

import jp.agentec.abook.abv.bl.common.constant.ABookCommConstants;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;
import jp.agentec.abook.abv.bl.dto.ChatMessageDto;
import jp.agentec.abook.abv.bl.dto.ChatRoomDto;
import jp.agentec.adf.util.DateTimeUtil;

public class RoomListJSON extends AcmsCommonJSON {


    public ArrayList<ChatRoomDto> roomList;

    public RoomListJSON(String jsonString) throws AcmsException {
        super(jsonString);
    }

    @Override
    protected void parse(JSONObject json) throws JSONValidationException {

        // ルーム一覧情報を取得
        if (!json.has(ABookCommConstants.KEY.BODY)) { return; }

        JSONArray roomListJsonArray = json.getJSONObject(ABookCommConstants.KEY.BODY).getJSONArray(ABookCommConstants.KEY.CHAT_ROOM_INFO_LIST);
        if (roomListJsonArray == null) { return; }

        roomList = new ArrayList<ChatRoomDto>();
        for (int listCount = 0; listCount < roomListJsonArray.length(); listCount++) {
            if (roomListJsonArray.getJSONObject(listCount).length() == 0) {
                break;
            }
            ChatRoomDto chatRoomDto = new ChatRoomDto();
            ChatMessageDto chatMessageDto = new ChatMessageDto();

            chatRoomDto.chatRoomId = roomListJsonArray.getJSONObject(listCount).getInt(ABookCommConstants.KEY.ROOM_ID);
            chatRoomDto.chatRoomName = roomListJsonArray.getJSONObject(listCount).getString(ABookCommConstants.KEY.ROOM_NAME);
            chatRoomDto.type = roomListJsonArray.getJSONObject(listCount).getInt(ABookCommConstants.KEY.ROOM_TYPE);
            chatRoomDto.unreadCount =  roomListJsonArray.getJSONObject(listCount).has(ABookCommConstants.KEY.UNREAD_COUNT) ? roomListJsonArray.getJSONObject(listCount).getInt(ABookCommConstants.KEY.UNREAD_COUNT) : 0;
            chatRoomDto.userCount = roomListJsonArray.getJSONObject(listCount).getJSONArray(ABookCommConstants.KEY.ATTEND_USERS).length();

            //最後メッセージ情報がある場合の処理
            JSONObject lastMessageInfoJSON = roomListJsonArray.getJSONObject(listCount).has(ABookCommConstants.KEY.LAST_MESSAGE_INFO) ? roomListJsonArray.getJSONObject(listCount).getJSONObject(ABookCommConstants.KEY.LAST_MESSAGE_INFO) : null;
            if (lastMessageInfoJSON != null && lastMessageInfoJSON.has(ABookCommConstants.KEY.MESSAGE_ID)) {
                chatMessageDto.chatRoomId = chatRoomDto.chatRoomId;
                chatMessageDto.messageType = lastMessageInfoJSON.getInt(ABookCommConstants.KEY.MESSAGE_TYPE);
                if (ABookCommConstants.FLAG.MESSAGE_TYPE.COLLABORATION_START.equals(chatMessageDto.messageType)
                        || ABookCommConstants.FLAG.MESSAGE_TYPE.COLLABORATION_END.equals(chatMessageDto.messageType)) {
                    chatMessageDto.message = lastMessageInfoJSON.getJSONObject(ABookCommConstants.KEY.MESSAGE).toString();
                } else {
                    chatMessageDto.message = lastMessageInfoJSON.getString(ABookCommConstants.KEY.MESSAGE);
                }
                if (lastMessageInfoJSON.has(ABookCommConstants.KEY.INSERT_DATE)) {
                    chatMessageDto.insertDate = DateTimeUtil.millToDateString(lastMessageInfoJSON.getJSONObject(ABookCommConstants.KEY.INSERT_DATE).getLong(ABookCommConstants.KEY.TIME));
                }
                chatMessageDto.shopMemberId = lastMessageInfoJSON.getInt(ABookCommConstants.KEY.SHOP_MEMBER_ID);
                chatMessageDto.chatMessageId = lastMessageInfoJSON.getInt(ABookCommConstants.KEY.MESSAGE_ID);
                chatRoomDto.lastMessageInfo = chatMessageDto;
            }
            JSONArray attendUsers = roomListJsonArray.getJSONObject(listCount).getJSONArray(ABookCommConstants.KEY.ATTEND_USERS);

            ArrayList<Integer> attendUserList = new ArrayList<Integer>();
            for (int attendUserCount = 0; attendUserCount < attendUsers.length(); attendUserCount++) {
                attendUserList.add((Integer) attendUsers.get(attendUserCount));
            }
            chatRoomDto.attendUsers = attendUserList;
            roomList.add(chatRoomDto);
        }
    }
}

