package jp.agentec.abook.abv.bl.acms.client.json;

import java.util.ArrayList;

import jp.agentec.abook.abv.bl.acms.client.AcmsClient;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;
import jp.agentec.abook.abv.bl.dto.ServiceOptionDto;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

/**
 * {@link AcmsClient#serviceOption} の戻り値です。
 * @author Taejin Hong
 * @version 1.0.0
 */
public class ServiceOptionsJSON extends AcmsCommonJSON {
	public static final String ServiceOptionList = "serviceOptionList";
	public static final String ServiceOptionId = "serviceOptionId";
	public static final String ServiceName = "serviceName";
	public static final String Value = "value";
	
	public ArrayList<ServiceOptionDto> serviceOptionList;

	public ServiceOptionsJSON(String jsonString) throws AcmsException {
		super(jsonString);
	}

	@Override
	protected void parse(JSONObject json) throws JSONValidationException {
		if (json.has(ServiceOptionList)) {
			JSONArray jarr = json.getJSONArray(ServiceOptionList);
			
			int count = jarr.length();
			serviceOptionList = new ArrayList<ServiceOptionDto>();
			
			for (int i = 0; i < count; i++) {
				JSONObject item = jarr.getJSONObject(i);
				int serviceOptionId = getInt(item, ServiceOptionId);
				String serviceOptionName = getString(item, ServiceName);
				String value = getString(item, Value);
				serviceOptionList.add(new ServiceOptionDto(serviceOptionId, serviceOptionName, value));
			}
		} else {
			throw new JSONValidationException(json.toString(), ServiceOptionList + " property not found.");
		}
	}
}
