package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

import java.util.ArrayList;

import jp.agentec.abook.abv.bl.common.constant.ABookCommConstants;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;
import jp.agentec.abook.abv.bl.dto.ShopMemberDto;

public class UserInviteResultJSON extends AcmsCommonJSON {

    public Integer roomId;

    public UserInviteResultJSON(String jsonString) throws AcmsException {
        super(jsonString);
    }

    @Override
    protected void parse(JSONObject json) throws JSONValidationException {

        if (!json.has(ABookCommConstants.KEY.BODY)) { return; }

        JSONObject invateResultJson = json.getJSONObject(ABookCommConstants.KEY.BODY);
        if (invateResultJson == null) { return; }

        if (invateResultJson.has(ABookCommConstants.KEY.ROOM_ID)) {
            roomId = invateResultJson.getInt(ABookCommConstants.KEY.ROOM_ID);
        }
    }
}

