package jp.agentec.abook.abv.bl.acms.client.parameters;

/**
 * ユーザIDとUDIDの関連を削除するためのパラメータです。
 * @author Taejin Hong
 * @version 1.0.0
 */
public class AccountInitializeParameters extends AcmsParameters {
	private String udid;
	private String appId;
	
	/**
	 * {@link AccountInitializeParameters} クラスのインスタンスを初期化します。
	 * @param sid ログインした時のセッションIDです。
	 * @param udid 端末のUDIDです。
	 * @param appId　アプリIDです。（iPad:1, android:3）
	 * @since 1.0.0
	 */
	public AccountInitializeParameters(String sid, String udid, String appId) {
		super(sid);
		
		this.udid = udid;
		this.appId = appId;
	}

	/**
	 * 端末のUDIDを返します。
	 * @return 端末のUDIDです。
	 * @since 1.0.0
	 */
	public String getUdid() {
		return udid;
	}

	/**
	 * アプリIDを返します。
	 * @return　アプリIDです。（iPad:1, android:3）
	 * @since 1.0.0
	 */
	public String getAppId() {
		return appId;
	}
}
