package jp.agentec.abook.abv.bl.acms.client.parameters;

import jp.agentec.adf.net.http.HttpParameterObject;

/**
 * ACMSのAPIに渡す共通的なパラメータを格納します。ACMSのAPIのパラメータ用クラスを作成するときはこのクラスを継承してください。<br>
 * ただし、このクラスはログイン状態の確認用として使われる {@link ChangeCollaborationParameters#sid} を持っているため、ログイン用のパラメータ {@link MobileLoginParameters} は、このクラスを継承する必要はありません。
 * @author lee-mk
 * @version 1.0.0
 */
public class ChangeCollaborationParameters extends HttpParameterObject {
    /**
     * セッションID
     * @since 1.0.0
     */
    private String sid;
    private String cmd;
    private Integer roomId;
    private Integer collaborationType;
    private Integer meetingId;

    /**
     * {@link ChangeCollaborationParameters} のインスタンスを初期化します。
     * @param sid ログインした時のセッションIDです。
     * @param cmd Apiリクエストに必要なコマンド（ABOOK COMM専用）。
     * @param roomId roomId
     * @param meetingId meetingId
     * @since 1.0.0
     */
    public ChangeCollaborationParameters(String sid, String cmd, Integer roomId, Integer collaborationType, Integer meetingId) {
        this.sid = sid;
        this.cmd = cmd;
        this.roomId = roomId;
        this.collaborationType = collaborationType;
        this.meetingId = meetingId;
    }

    /**
     * セッションIDを返します。
     * @return ログインした時のセッションIDです。
     * @since 1.0.0
     */
    public String getSid() {
        return sid;
    }

    /**
     * コマンドを返します。
     * @return ログインした時のセッションIDです。
     * @since 1.0.0
     */
    public String getCmd() {
        return cmd;
    }

    /**
     * roomIdを返します。
     * @return roomId
     * @since 1.0.0
     */
    public Integer getRoomId() {
        return roomId;
    }

    /**
     * meetingIdを返します。
     * @return meetingId
     * @since 1.0.0
     */
    public Integer getMeetingId() {
        return meetingId;
    }

    /**
     * collaborationTypeを返します。
     * @return collaborationType
     * @since 1.0.0
     */
    public Integer getCollaborationType() {
        return collaborationType;
    }
}
