package jp.agentec.abook.abv.bl.data.tables;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.abook.abv.bl.data.DatabaseVersions;
import jp.agentec.adf.util.StringUtil;

/**
 * ジャンルのマスターテーブルです。
 * parent_category_id、category_relation_id
 * @author Taejin Hong
 * @version 1.1.1
 */
public class MCategory extends SQLiteTableScript {

	public MCategory() {
	}
	
	@Override
	public List<String> getCreateScript(int version) {
		List<String> ddl = new ArrayList<String>();
		StringBuffer sql = new StringBuffer();
		
		//	since 1.0.0

		sql.append(" CREATE TABLE m_category ( ");
		sql.append("        category_relation_id INTEGER NOT NULL  ");//	relation enumaerationパターンを適用する。since DatabaseVersions.Ver1_5_0
		sql.append("      , category_id INTEGER NOT NULL ");
		sql.append("      , parent_category_id INTEGER NOT NULL ");//	parent enumaerationパターンを適用する。since DatabaseVersions.Ver1_5_0
		sql.append("      , category_name VARCHAR(64) NOT NULL ");
		sql.append("      , disp_order INTEGER NOT NULL ");
		sql.append("      , category_path TEXT NOT NULL ");	//	path enumaerationパターンを適用する。since DatabaseVersions.Ver1_5_0
		sql.append("      , PRIMARY KEY (category_relation_id) ");
		sql.append(" ) ");
		
		ddl.add(sql.toString());
		StringUtil.clear(sql);

		sql.append(" CREATE INDEX idx_category_1 ON m_category ( ");
		sql.append("        parent_category_id ");
		sql.append(" )  ");
		
		ddl.add(sql.toString());
		StringUtil.clear(sql);
		
//		sql.append(" CREATE UNIQUE INDEX udx_category_1 ON m_category ( "); // 不要
//		sql.append("        category_id, parent_category_id ");
//		sql.append(" ) ");
//
//		ddl.add(sql.toString());
//		StringUtil.clear(sql);
		//	since DatabaseVersions.Ver1_5_0
		sql.append(" CREATE INDEX idx_category_2 ON m_category ( ");
		sql.append("         category_path ");
		sql.append(" ) ");	
		
		ddl.add(sql.toString());
		
		ddl.add(" CREATE INDEX idx_category_order_name ON m_category (disp_order, category_name) ");

		return ddl;
	}

	@Override
	public List<String> getUpgradeScript(int oldVersion, int newVersion) {
		return null;
	}

	@Override
	public List<String> getMigrationScript(SQLiteDatabase databaseConnection, int oldVersion, int newVersion, Object... params) {
		return null;
	}

}
