package jp.agentec.abook.abv.bl.data.tables;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;

public class RContentGroup extends SQLiteTableScript {
	
	public RContentGroup() {
		super();
	}
	
	@Override
	public List<String> getCreateScript(int version) {
		List<String> ddl = new ArrayList<String>();
		StringBuffer sql = new StringBuffer();
		
		//	since 1.0.0
		sql.append(" CREATE TABLE r_content_group ( ");
		sql.append("        content_id BIGINT NOT NULL ");
		sql.append("      , group_relation_id INTEGER NOT NULL ");
		sql.append("      , PRIMARY KEY (content_id, group_relation_id)      ");
		sql.append("      , FOREIGN KEY (content_id) REFERENCES t_content (content_id) ");
		sql.append("      , FOREIGN KEY (group_relation_id) REFERENCES m_group (group_relation_id)      ");
		sql.append(" ) ");
		
		ddl.add(sql.toString());
		
		return ddl;
	}

	@Override
	public List<String> getUpgradeScript(int oldVersion, int newVersion) {
		return null;
	}

	@Override
	public List<String> getMigrationScript(SQLiteDatabase databaseConnection, int oldVersion, int newVersion, Object... params) {
		return null;
	}

}
