package jp.agentec.abook.abv.bl.data.tables;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.abook.abv.bl.data.DatabaseVersions;

public class TContentMemo extends SQLiteTableScript {
	
	public TContentMemo() {
	}
	
	@Override
	public List<String> getCreateScript(int version) {
		List<String> ddl = new ArrayList<String>();
		StringBuffer sql = new StringBuffer();
		
		//	since 1.0.0
		sql.append(" CREATE TABLE t_content_memo ( ");
		sql.append("        content_id BIGINT NOT NULL ");
		sql.append("      , memo_id VARCHAR(64) NOT NULL");	//	since ABook Plus 1.0
		sql.append("      , page_num INTEGER NOT NULL ");
		sql.append("      , axis_x SMALLINT NOT NULL ");
		sql.append("      , axis_y SMALLINT NOT NULL ");
		sql.append("      , memo TEXT NOT NULL ");
		sql.append("      , copy_flg BOOLEAN DEFAULT false ");	//	since 1.5.2.01
		sql.append("      , del_flg BOOLEAN DEFAULT false ");	//	since 1.5.2.01
		sql.append("      , insert_date DATETIME NOT NULL ");
		sql.append("      , update_date DATETIME NOT NULL ");	//	since ABook Plus 1.2(1.2以前のアプリはUNIQUE INDEXのみ作成)
		sql.append("      , PRIMARY KEY (memo_id) ");
		sql.append("      , FOREIGN KEY (content_id) REFERENCES t_content (content_id) ");
		sql.append(" ) ");
		
		ddl.add(sql.toString());
		
		return ddl;
	}

	@Override
	public List<String> getUpgradeScript(int oldVersion, int newVersion) {
		return null;
	}

	@Override
	public List<String> getMigrationScript(SQLiteDatabase databaseConnection, int oldVersion, int newVersion, Object... params) {
		return null;
	}

}
