package jp.agentec.abook.abv.bl.logic;

import java.util.List;
import java.util.UUID;

import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.data.dao.AbstractDao;
import jp.agentec.abook.abv.bl.data.dao.ContentMarkingDao;
import jp.agentec.abook.abv.bl.data.dao.MarkingSettingDao;
import jp.agentec.abook.abv.bl.dto.ContentMarkingDto;
import jp.agentec.abook.abv.bl.dto.MarkingSettingDto;
import jp.agentec.adf.util.DateTimeUtil;

public class MarkingLogic extends AbstractLogic {
	private ContentMarkingDao contentMarkingDao = AbstractDao.getDao(ContentMarkingDao.class);
	private MarkingSettingDao markingSettingDao = AbstractDao.getDao(MarkingSettingDao.class);

	/**
	 * 指定したコンテンツの該当ページのマーキング情報を追加します。<br>
	 * 既に存在する場合更新します。
	 * 
	 * @param contentId
	 * @param pageNum
	 * @param fileName
	 */
	public void insertUpdateContentMarking(long contentId, int pageNum, String fileName) {
		ContentMarkingDto dto = contentMarkingDao.getMarking(contentId, pageNum);

		// 既に存在する場合、日付だけ更新
		if (dto == null) {
			dto = new ContentMarkingDto();
			dto.contentId = contentId;
			dto.pageNum = pageNum;
			dto.markingId = UUID.randomUUID().toString();
			dto.fileName = fileName;
			dto.insertDate = DateTimeUtil.getCurrentUTCDate();
			dto.updateDate = DateTimeUtil.getCurrentUTCDate();
			Logger.v("MarkingLogic", "[insertUpdateContentMarking][insert]ContentMarking.insertDate=" + dto.insertDate);
			Logger.v("MarkingLogic", "[insertUpdateContentMarking][update]ContentMarking.updateDate=" + dto.updateDate);
			contentMarkingDao.insertMarking(dto);

		} else {
			dto.updateDate = DateTimeUtil.getCurrentUTCDate();
			Logger.v("MarkingLogic", "[insertUpdateContentMarking][insert]ContentMarking.insertDate=" + dto.insertDate);
			Logger.v("MarkingLogic", "[insertUpdateContentMarking][update]ContentMarking.updateDate=" + dto.updateDate);
			contentMarkingDao.updateMarking(dto);
		}
	}
	
	public void updateMarkingSetting(int id, int color, int width) {
		MarkingSettingDto dto = markingSettingDao.getMarkingSettingDto(id);
		dto.color = color;
		dto.width = width;
		dto.updateDate = DateTimeUtil.getCurrentUTCDate();
		markingSettingDao.updateMarkingSetting(dto);
	}

	public List<MarkingSettingDto> getMarkingSettingList() {
		return markingSettingDao.getMarkingSettingList();
	}
}
