package jp.agentec.abook.abv.bl.websocket;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;

import javax.net.ssl.X509TrustManager;

public class CheatTrustManager implements X509TrustManager {
    private ArrayList<X509Certificate> issuersList = new ArrayList<X509Certificate>();
    public CheatTrustManager() {
    }
    
    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain != null) {
            for (int i = 0; i < chain.length; i++) {
                issuersList.add(chain[i]);
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain != null) {
            for (int i = 0; i < chain.length; i++) {
                issuersList.add(chain[i]);
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return issuersList.toArray(new X509Certificate[0]);
    }
}
