package jp.agentec.abook.abv.bl.data.dao;

import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteOpenHelper;
import jp.agentec.abook.abv.bl.common.db.impl.JDBCSQLiteOpenHelper;
import jp.agentec.abook.abv.bl.data.DBConnector;
import jp.agentec.abook.abv.bl.dto.ContentObjectLogDto;
import jp.agentec.adf.util.DateTimeUtil;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ContentObjectLogDaoTest extends TestCase {

	private ContentObjectLogDao dao = new ContentObjectLogDao();

	public ContentObjectLogDaoTest(String string) {
		super(string);
	}

	@Override
	protected void setUp() throws Exception {
		super.setUp();

		DBConnector conn = DBConnector.getInstance();
		SQLiteOpenHelper sqlLiteOpenHelper = new JDBCSQLiteOpenHelper("test.db", 0);
		conn.setSqlLiteOpenHelper(sqlLiteOpenHelper);
		((JDBCSQLiteOpenHelper) sqlLiteOpenHelper).onCreate(conn.getDatabase());
	}

	public static TestSuite suite() {
		TestSuite suite = new TestSuite("ContentObjectLogDaoTest");
//		suite.addTest(new ContentObjectLogDaoTest("testInsertContentObjectLog"));
		suite.addTest(new ContentObjectLogDaoTest("testUpdateContentObjectLog"));
//		suite.addTest(new ContentObjectLogDaoTest("testInsertZoomLog"));
		return suite;
	}

	@Override
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testInsertContentObjectLog() {
		ContentObjectLogDto dto = new ContentObjectLogDto();
		dto.objectLogId = dao.getNewContentObjectLogId();
		dto.readingLogId = 1;
		dto.actionDate = DateTimeUtil.getCurrentDate();
		dto.contentId = 1000;
		dto.pageNum = 0;
		dto.objectId = 1;
		dto.resourceId = 8000;
		dto.mediaType = 3;
		dto.actionType = 1;
		dto.actionValue = "action:aaaa";
		dto.actionTime = 30;
		dto.locationX = 100;
		dto.locationY = 200;
		dto.locationHeight = 150;
		dto.locationWidth = 250;
		dto.eventType = "0";
		dao.insertContentObjectLog(dto);
	}

	public void testUpdateContentObjectLog() {
		List<ContentObjectLogDto> list = dao.getContentObjectLogs(1000, 1);

		for (ContentObjectLogDto dto : list) {
			dto.readingLogId = 1;
			dto.actionDate = DateTimeUtil.getCurrentDate();
			dto.contentId = 2;
			dto.pageNum = 3;
			dto.objectId = 4;
			dto.resourceId = 5;
			dto.mediaType = 6;
			dto.actionType = 7;
			dto.actionValue = "action:bbbb";
			dto.actionTime = 8;
			dto.locationX = 9;
			dto.locationY = 10;
			dto.locationHeight = 11;
			dto.locationWidth = 12;
			dto.eventType = "1";
			dao.updateContentObjectLog(dto);
		}
	}
}
