package jp.agentec.abook.abv.bl.common.db.impl;

import jp.agentec.abook.abv.bl.common.db.SQLiteStatement;
import jp.agentec.abook.abv.bl.common.log.Logger;

public class StandardSQLiteStatement implements SQLiteStatement {
	private android.database.sqlite.SQLiteStatement stmt;

	public StandardSQLiteStatement(android.database.sqlite.SQLiteStatement stmt) {
		this.stmt = stmt;
	}

	@Override
	public void execute() {
		stmt.execute();
	}

	@Override
	public long executeInsert() {
		return stmt.executeInsert();
	}

	@Override
	public long simpleQueryForLong() {
		return stmt.simpleQueryForLong();
	}

	@Override
	public String simpleQueryForString() {
		return stmt.simpleQueryForString();
	}

	@Override
	public void bindNull(int index) {
		stmt.bindNull(index);
	}

	@Override
	public void bindLong(int index, long value) {
		stmt.bindLong(index, value);
	}

	@Override
	public void bindDouble(int index, double value) {
		stmt.bindDouble(index, value);
	}

	@Override
	public void bindString(int index, String value) {
		stmt.bindString(index, value);
	}

	@Override
	public void bindBlob(int index, byte[] value) {
		stmt.bindBlob(index, value);
	}

	@Override
	public void close() {
		try {
			stmt.close();
		} catch (Exception e) { // finallyで呼ばれるため例外はスローしないようにする
			Logger.e("StandardSQLiteStatement", "close error.", e);
		}
	}
}
