package jp.agentec.abook.abv.cl.push;

import android.content.Intent;

import org.json.adf.JSONObject;

import jp.agentec.abook.abv.bl.common.constant.ABookCommConstants;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType;
import jp.agentec.adf.util.StringUtil;


/**
 * プッシュメッセージをJSONにしたクラス
 * 既存のデータのキーは、AppDefType.PushMessageKey
 * チャットで追加されたデータのキーは、AppDefType.ChatPushMessageKey
 */
public class PushMessageJSON {
    private JSONObject jsonObject;

    public PushMessageJSON(String jsonText) {
        jsonObject = new JSONObject(jsonText);
    }

    // プッシュメッセージデータ
    public String getMessage() {
        return jsonObject.getString(AppDefType.PushMessageKey.message);
    }

    public String getData() {
        try {
            return jsonObject.getString(AppDefType.PushMessageKey.data);
        } catch (Exception e) {
            return "";
        }
    }

    public String getOperationID() {
        try {
            return jsonObject.getString(AppDefType.PushMessageKey.operationId);
        } catch (Exception e) {
            return "";
        }
    }

    // ここからチャットデータ
    public String getRoomName() {
        try {
            return jsonObject.getString(AppDefType.ChatPushMessageKey.roomName);
        } catch (Exception e){
            return "";
        }
    }

    public Long getRoomId() {
        try {
            return jsonObject.getLong(AppDefType.ChatPushMessageKey.roomId);
        } catch (Exception e){
            return new Long(0);
        }
    }

    public String getRoomType() {
        try {
//            int roomType = jsonObject.getInt(AppDefType.ChatPushMessageKey.roomType);
//            return Integer.toString(roomType);
            return "";
        } catch (Exception e){
            return "";
        }
    }

    public String getPushSendLoginId() {
        try {
            return jsonObject.getString(AppDefType.ChatPushMessageKey.pushSendLoginId);
        } catch (Exception e) {
            return "";
        }
    }

    public long getPushSendDate() {
        try {
            return jsonObject.getLong(AppDefType.ChatPushMessageKey.pushSendDate);
        } catch (Exception e) {
            return 0;
        }
    }
}
