package jp.agentec.abook.abv.launcher.android;

import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import androidx.core.content.FileProvider;
import android.util.Log;
import android.widget.Toast;

import java.io.File;

import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.log.Logger;

import static android.content.ContentValues.TAG;

/**
 * 新しいAPKのダウンロードが完了したときの通知を受け取る
 * @author jang
 *
 */
public class OnAppDownloadReceiver extends BroadcastReceiver {

	@Override
	public void onReceive(Context context, Intent intent) {
		if (DownloadManager.ACTION_DOWNLOAD_COMPLETE.equals(intent.getAction())) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                return;
            }

			long id = intent.getLongExtra(DownloadManager.EXTRA_DOWNLOAD_ID, -1);
			Logger.d("Download Complete ID : " + id);

            String downloadedTo = null;
            DownloadManager dm = (DownloadManager)context.getSystemService(context.DOWNLOAD_SERVICE);
            final Cursor cursor;
            if (dm != null) {
                // 現在ダウンロードされたファイルを確認する。
                cursor = dm.query(
                        new DownloadManager.Query().setFilterById(id));
                if (cursor.moveToFirst()) {
                    downloadedTo = cursor.getString(
                            cursor.getColumnIndex(DownloadManager.COLUMN_LOCAL_URI));
                    Log.d(TAG, "The file has been downloaded to: " + downloadedTo);

                    if (downloadedTo != null && !downloadedTo.endsWith(".apk")) {
                        Toast.makeText(context, context.getResources().getString(R.string.download_success), //To notify the Client that the file is being downloaded
                                Toast.LENGTH_LONG).show();
                        return;
                    }
                }
            }

            if (id == -1) {
                // ダウンロードマネージャの通知領域をクリックした場合はメッセージ表示のみ
                Toast.makeText(context, intent.getAction(), Toast.LENGTH_LONG).show();
            } else {
                // APKファイルの場合
                if (downloadedTo != null && downloadedTo.toLowerCase().endsWith(".apk")) {
                    File file = new File(context.getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS), ABVEnvironment.APK_FILE_NAME);
                    if (file.exists()) {
                        try {
                            // Android7でアップデート
                            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                                Uri apkUri = FileProvider.getUriForFile(context, context.getPackageName() + ".provider", file);
                                Intent updateIntent = new Intent(Intent.ACTION_VIEW);
                                updateIntent.setDataAndType(apkUri, "application/vnd.android.package-archive");
                                updateIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                                updateIntent.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION);
                                context.startActivity(updateIntent);
                            } else {
                                Intent i = new Intent(Intent.ACTION_VIEW);
                                // Activity以外からActivityを呼び出すためのフラグを設定
                                i.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                                i.setDataAndType(Uri.fromFile(file), "application/vnd.android.package-archive");
                                context.startActivity(i);
                            }
                        } catch (Exception ex) {
                            Logger.e("OnAppDownloadReceiver.startActivity(fileIntent).", ex);
                        }
                    } else {
                        Toast.makeText(context, "No Exist APK File: ", Toast.LENGTH_LONG).show();
                    }
                }
            }
		}
	}

}
