package jp.agentec.abook.abv.ui.common.util;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.dialog.ABookAlertDialog;

import android.content.Context;
import android.content.DialogInterface;
import android.view.Gravity;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ScrollView;
import android.widget.TextView;
public class AlertDialogUtil {

	public static ABookAlertDialog createABookAlertDialog(Context context) {
		ABookAlertDialog alertDialog = new ABookAlertDialog(context);
		alertDialog.setIcon(R.drawable.icon);
		return alertDialog;
	}
	
	public static ABookAlertDialog createAlertDialog(Context context, int titleId) {
		ABookAlertDialog alertDialog = createABookAlertDialog(context);
		alertDialog.setTitle(titleId);
		return alertDialog;
	}
	
	public static ABookAlertDialog createAlertDialog(Context context, String title) {
		ABookAlertDialog alertDialog = createABookAlertDialog(context);
		alertDialog.setTitle(title);
		return alertDialog;
	}
	
	public static ABookAlertDialog createAlertDialog(Context context, int titleId, int messageId) {
		ABookAlertDialog alertDialog = createABookAlertDialog(context);
		alertDialog.setTitle(titleId);
		alertDialog.setMessage(messageId);
		return alertDialog;
	}
	
	public static ABookAlertDialog createAlertDialog(Context context, String title, String message) {
		ABookAlertDialog alertDialog = createABookAlertDialog(context);
		alertDialog.setTitle(title);
		alertDialog.setMessage(message);
		return alertDialog;
	}
	/**
	 * 共通ダイアログ表示用（Cancel表示・非表示、OKボタンコールバック）
	 * @param context コンテキスト
	 * @param title タイトル　文字列
	 * @param message メッセージ　文字列
	 * @param isCancleButtonHidden Cancelボタン表示(false)・非表示（true）
	 * @param okOnClick　OKボタンコールバック
	 */
	public static void showAlertDialog(Context context, String title, String message, boolean isCancleButtonHidden, DialogInterface.OnClickListener okOnClick) {

		ABookAlertDialog alertDialog = createAlertDialog(context, title, message);
		if (!isCancleButtonHidden) {
			alertDialog.setNegativeButton(R.string.cancel, null);
		}
		alertDialog.setCancelable(false);
		alertDialog.setPositiveButton(R.string.ok, okOnClick);
		alertDialog.show();
	}

	/**
	 * 共通ダイアログ表示用（OKボタンコールバック、CANCELボタンコールバック）
	 * @param context コンテキスト
	 * @param title タイトル
	 * @param message メッセージ
	 * @param okOnClick　OKボタンコールバック
	 * @param okOnClick　CANCELボタンコールバック
	 */
	public static void showAlertDialog(Context context, int title, int message, DialogInterface.OnClickListener okOnClick, DialogInterface.OnClickListener canOnClick) {
		ABookAlertDialog alertDialog = createAlertDialog(context, context.getResources().getString(title), context.getResources().getString(message));
		alertDialog.setNegativeButton(R.string.cancel, canOnClick);
		alertDialog.setPositiveButton(R.string.ok, okOnClick);
		alertDialog.setCancelable(false);
		alertDialog.show();
	}

	/**
	 * 共通ダイアログ表示用（Cancel表示・非表示、OKボタンコールバック）
	 * @param context コンテキスト
	 * @param title タイトル
	 * @param message メッセージ
	 * @param isCancleButtonHidden Cancelボタン表示(false)・非表示（true）
	 * @param okOnClick　OKボタンコールバック
	 */
	public static void showAlertDialog(Context context, int title, int message, boolean isCancleButtonHidden, DialogInterface.OnClickListener okOnClick) {

		ABookAlertDialog alertDialog = createAlertDialog(context, context.getResources().getString(title), context.getResources().getString(message));
		if (!isCancleButtonHidden) {
			alertDialog.setNegativeButton(R.string.cancel, null);
		}
		alertDialog.setCancelable(false);
		alertDialog.setPositiveButton(R.string.ok, okOnClick);
		alertDialog.show();
	}

	public static void showAlertDialog(Context context, int title, int message) {
		showAlertDialog(context, title, message, true, null);
	}

	public static ABookAlertDialog deleteContentAlertDialog(Context context, int deleteMessage) {
		ABookAlertDialog alertDialog = createAlertDialog(context, R.string.delete);
		alertDialog.setMessage(deleteMessage);
		return alertDialog;
	}
	
	public static ABookAlertDialog deleteContentAlertDialog(Context context) {
		return deleteContentAlertDialog(context, R.string.message_delete_content);
	}
	
	public static ABookAlertDialog scrollableAlertDialog(Context context, int titleId, String message) {
		ABookAlertDialog alertDialog = createAlertDialog(context, titleId);
		TextView txtMsg = new TextView(context);
		txtMsg.setText(message);
		txtMsg.setTextColor(context.getResources().getColor(R.color.text_select));
		txtMsg.setTextSize(20);
		txtMsg.setGravity(Gravity.LEFT | Gravity.CENTER_VERTICAL);

		int FP = ViewGroup.LayoutParams.MATCH_PARENT;
		FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(FP, FP);
		params.leftMargin = 10;
		ScrollView scrollView = new ScrollView(context);
		scrollView.addView(txtMsg, params);
		scrollView.setLayoutParams(new FrameLayout.LayoutParams(FP, FP));
		alertDialog.setView(scrollView);
		return alertDialog;
	}
}
