package jp.agentec.abook.abv.ui.common.view;

import android.app.Dialog;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.util.DisplayMetrics;
import android.view.ViewGroup.LayoutParams;
import android.view.WindowManager;

public class ABVDialog extends Dialog {

	private boolean isNormalSize = false;
	private Resources mRes;
	
	public ABVDialog(Context context) {
		super(context);
		mRes = context.getResources();
//		requestWindowFeature(Window.FEATURE_LEFT_ICON);
	}

	public ABVDialog(Context context, int theme) {
		super(context, theme);
		mRes = context.getResources();
	}

	public ABVDialog(Context context, boolean cancelable, OnCancelListener cancelListener) {
		super(context, cancelable, cancelListener);
		mRes = context.getResources();
	}
	
	public void setNormalSizeFlag(boolean flag) {
		isNormalSize = flag;
	}
	
	protected Resources getResources() {
		return mRes;
	}
	
	
	@Override
	public void show() {
		
		DisplayMetrics metrics = getContext().getResources().getDisplayMetrics();
        if(getWindow() != null) {
            WindowManager.LayoutParams lp = getWindow().getAttributes();

            if (isNormalSize) {
//			lp.width = metrics.widthPixels;
//			lp.height = metrics.heightPixels;
                getWindow().setLayout(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
                getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            } else {
                int dialogWidth;
                if (metrics.widthPixels > metrics.heightPixels) {
                    dialogWidth = (int) (metrics.heightPixels * 0.8);
                } else {
                    dialogWidth = (int) (metrics.widthPixels * 0.8);
                }
                lp.width = dialogWidth;
                lp.height = dialogWidth;
            }

            getWindow().setAttributes(lp);
        }
		super.show();
//		setFeatureDrawableResource(Window.FEATURE_LEFT_ICON, R.drawable.icon);
	}

}
