package jp.agentec.abook.abv.ui.home.activity;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Color;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.acms.client.json.content.ContentJSON;
import jp.agentec.abook.abv.bl.acms.type.AcmsApis;
import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.constant.ABookCommConstants;
import jp.agentec.abook.abv.bl.common.exception.ExceptionHandler;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.data.ABVDataCache;
import jp.agentec.abook.abv.bl.download.ContentZipDownloadNotification;
import jp.agentec.abook.abv.bl.dto.CategoryContentDto;
import jp.agentec.abook.abv.bl.dto.ContentDto;
import jp.agentec.abook.abv.bl.logic.AbstractLogic;
import jp.agentec.abook.abv.bl.logic.OperationLogic;
import jp.agentec.abook.abv.bl.websocket.MeetingManager;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.activity.ABVUIActivity;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType;
import jp.agentec.abook.abv.ui.common.constant.ErrorCode;
import jp.agentec.abook.abv.ui.common.constant.ErrorMessage;
import jp.agentec.abook.abv.ui.common.constant.NaviConsts;
import jp.agentec.abook.abv.ui.common.dialog.ABookAlertDialog;
import jp.agentec.abook.abv.ui.common.util.ABVToastUtil;
import jp.agentec.abook.abv.ui.common.util.AlertDialogUtil;
import jp.agentec.abook.abv.ui.common.util.PatternStringUtil;
import jp.agentec.abook.abv.ui.home.adapter.OperationRelatedContentSectionAdapter;
import jp.agentec.abook.abv.ui.home.helper.ActivityHandlingHelper;
import jp.agentec.abook.abv.ui.viewer.activity.OnlineHTMLWebViewActivity;
import jp.agentec.adf.util.StringUtil;

/**
 * Created by kim, changgyun on 2018/09/10.
 */

public class OperationRelatedContentActivity extends ABVUIActivity {
    private static final String TAG = "OperationRelatedContentActivity";

    private OperationRelatedContentSectionAdapter mOperationRelatedContentSectionAdapter;

    private LinearLayout dashboardLayout;
    private ImageButton mDashboardHomeButton;
    private LinearLayout operationLayout;
    private ImageButton mOperationHomeButton;                   // ホームボタン
    private ImageButton mOperationRelatedContentButton;        //
    private ImageButton mQuickReportPrintButton;               // 簡易帳票印刷ボタン

    private TextView mTxtOperationRelatedContent;
    private Button mAllSaveButton;
    private boolean isCollaboration;
    private boolean isCollaborationOwner;
    private ListView mContentListView;
    private List<CategoryContentDto> mOperationContentList;
    private LinearLayout mToolbar;
    private MeetingManager meetingManager = MeetingManager.getInstance();
    private OperationLogic mOperationLogic = AbstractLogic.getLogic(OperationLogic.class);
    TextView mWaitOwnerTextView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        Logger.i(TAG,"onCreate");
        super.onCreate(savedInstanceState);
        updateCollaborationInfo();
        setContentView(R.layout.ac_operation_related_content);

        dashboardLayout = findViewById(R.id.dashboard_layout);
        mDashboardHomeButton = (ImageButton) findViewById(R.id.btn_dashboard_home);
        // ホームボタン（作業一覧へ遷移ボタン）
        operationLayout = findViewById(R.id.operation_layout);
        mOperationHomeButton = (ImageButton) findViewById(R.id.btn_operation_home);
        // 共通資料ボタン
        mOperationRelatedContentButton = (ImageButton) findViewById(R.id.btn_common_content);
        // コミュニケーションボタン
        communicationButton = (ImageButton) findViewById(R.id.btn_communication_menu);
        // 一括保存ボタン
        mAllSaveButton = (Button) findViewById(R.id.btn_all_save);

        mContentListView = (ListView) findViewById(R.id.lv_content_list);
        showContentList();
        mTxtOperationRelatedContent = (TextView) findViewById(R.id.txt_operation_related_content);

        mQuickReportPrintButton = (ImageButton) findViewById(R.id.btn_operation_print);
            // リソースパターンの適用
        mTxtOperationRelatedContent.setText("" + PatternStringUtil.patternToString(getApplicationContext(),
                R.string.title_common_content,
                getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
        mToolbar = (LinearLayout)findViewById(R.id.toolbar2);
        mAllSaveButton.setVisibility(View.GONE);
        setOnButtonEvent();
        settingBottomToolbar();
        refreshCollaborationUI();
    }

    // 下辺のツールバー設定
    private void settingBottomToolbar() {
        mDashboardHomeButton.setEnabled(true);
        // ホームボタン活性化
        mOperationHomeButton.setEnabled(true);
        // 共通資料ボタンの非活性化
        mOperationRelatedContentButton.setEnabled(false);
        // バッチを付けるか判定して、イメージを設定
        setCommunicationImageButton();
        // コミュニケーションボタン
        communicationButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showCommunicationMenuDialog();
            }
        });
        if (findViewById(R.id.communication_layout) != null) {
            findViewById(R.id.communication_layout).setVisibility(View.GONE);
        }
        if (findViewById(R.id.print_layout) != null) {
            findViewById(R.id.print_layout).setVisibility(View.GONE);
        }
    }

    private void hideBottomToolbar() {
        mToolbar.setVisibility(View.GONE);
    }

    private void showBottomToolbar() {
        mToolbar.setVisibility(View.VISIBLE);
    }

    private void hideContentList() {
        mContentListView.setVisibility(View.GONE);
    }

    private void showContentList() {
        mContentListView.setVisibility(View.VISIBLE);
    }

    @Override
    public void onDownloadingContentZip(final ContentZipDownloadNotification notification) {
        super.onDownloadingContentZip(notification);

        ContentDto contentDto = null;
        for (CategoryContentDto categoryContentDto : mOperationContentList) {
            for (ContentDto dto : categoryContentDto.contentDtoArray) {
                if (dto.contentId == notification.getContentId()) {
                    contentDto = dto;
                    setDtoDownloadStatus(dto, notification);
                    break;
                }
            }
        }

        if (contentDto != null) {
            updateViewStatus(contentDto);
            updateViewSaveAll();
        }

    }

    private void setDtoDownloadStatus(ContentDto contentDto, ContentZipDownloadNotification notification) {
        contentDto.downloadingFlg = true;
        contentDto.isChecked = false;

        switch (notification.getDownloadStatus()) {
            case Waiting: //リソースダウンロード待機中
            case AutoPaused:
                break;
            case Downloading://リソースダウンロード中
                contentDto.downloadProgress = (int) notification.getDownloadRate();
                break;
            case Paused://リソースダウンロード一時停止
                contentDto.downloadProgress = (int) notification.getDownloadRate();
                break;
            case Initializing://初期化中
                contentDto.downloadProgress = 100;
                break;
            case Succeeded://成功
                try {
                    ContentDto content = contentDao.getContent(notification.getContentId());
                    contentDto.contentId = content.contentId;
                    contentDto.contentName = content.contentName;
                    contentDto.contentNameKana = content.contentNameKana;
                    contentDto.contentDetail = content.contentDetail;
                    contentDto.allPageNum = content.allPageNum;
                    contentDto.orientation = content.orientation;
                    contentDto.updatedFlg = content.updatedFlg;
                    contentDto.downloadedFlg = content.downloadedFlg;
                    contentDto.downloadingFlg = content.downloadingFlg;
                    contentDto.metaVersion = content.metaVersion;
                    contentDto.resourceVersion = content.resourceVersion;
                    contentDto.deliveryStartDate = content.deliveryStartDate;
                    contentDto.deliveryEndDate = content.deliveryEndDate;
                    contentDto.favoriteFlg = content.favoriteFlg;
                    contentDto.contentProtectedFlg = content.contentProtectedFlg;
                    contentDto.thumbnailNormalPath = content.thumbnailNormalPath;
                    contentDto.thumbnailBigPath = content.thumbnailBigPath;
                    contentDto.pagePath = content.pagePath;
                    contentDto.resourcePath = content.resourcePath;
                    contentDto.contentGroups = content.contentGroups;
                    contentDto.newFlg = content.newFlg;
                    contentDto.readingDate = content.readingDate;
                    contentDto.contentSize = content.contentSize;
                } catch (Exception e) {
                    Logger.e(TAG, "setDtoDownloadStatus failed.", e);
                    ErrorMessage.showErrorMessageToast(getApplicationContext(), ErrorCode.E107);
                }
                break;
            case Failed:
                if (ExceptionHandler.isNoSpaceLeftOnDeviceIOException(notification.getError())) {
                    ErrorMessage.showErrorMessageToast(getApplicationContext(), ErrorCode.STORAGE_ERROR);
                } else {
                    ABVToastUtil.showMakeText(getApplicationContext(), getResources().getString(R.string.download_error), Toast.LENGTH_LONG);
                }
                if (notification.getError() != null) {
                    Logger.e(TAG, notification.getError().toString());
                }
                contentDto.downloadingFlg = false;
                break;
            case Canceled:
                contentDto.downloadingFlg = false;
                break;
            case None:
                break;
            default:
                break;
        }
        contentDto.status = notification.getDownloadStatus().type();

        Logger.d(TAG, "contentId: %s, dlStatus: %s, dlRate:%s, dlSize=%s, fileSize:%s", notification.getContentId(), notification.getDownloadStatus(), notification.getDownloadRate(), notification.getDownloadedSize(), notification.getFileSize());
    }


    public void showOperationRelatedContentList() {
        mOperationContentList = mOperationLogic.getOperationRelatedContent();
        Logger.i(TAG, "count of content=" + mOperationContentList.size());

        // Gridビュー
        mOperationRelatedContentSectionAdapter = new OperationRelatedContentSectionAdapter(this, mOperationContentList, isNormalSize());
        mContentListView.setAdapter(mOperationRelatedContentSectionAdapter);

        mOperationRelatedContentSectionAdapter.setAdapterListener(new OperationRelatedContentSectionAdapter.OperationRelatedContentSectionListener() {
            @Override
            public boolean onContentDownload(long contentId) {
                return contentValidCheckAndDownload(contentId);
            }

            @Override
            public void onContentDownloadPause(ContentDto contentDto) {
                contentDownloadPause(contentDto.contentId);
                updateViewStatus(contentDto);
            }

            @Override
            public void onContentDownloadResume(ContentDto contentDto) {
                contentDownloadResume(contentDto);
                updateViewStatus(contentDto);
            }

            @Override
            public void onContentDelete(ContentDto contentDto) {
                showContentDeleteDialog(contentDto);
            }

            @Override
            public void onContentDownloadCancel(ContentDto contentDto) {
                showCancelDownloadDialog(contentDto);
            }

            @Override
            public void onOpenContentView(long contentId) {
                try {
                    ContentDto content = contentDao.getContent(contentId);
                    if (!content.downloadingFlg && content.downloadedFlg) {
                        // 遠隔連動 PDFとオリジナル以外の資料は対象外アラート表示
                        MeetingManager meetingManager = MeetingManager.getInstance();
                        if (meetingManager.isSendable() && !StringUtil.contains(content.contentType, new String[]{ContentJSON.KEY_PDF_TYPE, ContentJSON.KEY_NONE_TYPE})) {
                            showNonTargetMeetingContent();
                            return;
                        }

                        Intent intent = new Intent();
                        intent.putExtra(AppDefType.ChatPushMessageKey.baseActivityName, OperationRelatedContentActivity.class.getName());
                        ActivityHandlingHelper.getInstance().checkContentActivity(contentId, 0, intent);
                    }
                } catch (Exception e) {
                    Logger.e(TAG, "onOpenContentView failed.", e);
                    ErrorMessage.showErrorMessageToast(getApplicationContext(), ErrorCode.E107);
                }
            }

        });

        updateViewSaveAll();
    }

    /**
     * 遠隔支援中には対象外の資料のアラート表示
     */
    private void showNonTargetMeetingContent() {
        handler.post(new Runnable() {
            @Override
            public void run() {
                final ABookAlertDialog nonTargetMeetingContentDialog = AlertDialogUtil.createAlertDialog(OperationRelatedContentActivity.this, R.string.app_name);
                nonTargetMeetingContentDialog.setCancelable(false);
                nonTargetMeetingContentDialog.setMessage(isCollaboration? R.string.msg_non_target_collaboration_content : R.string.msg_non_target_meeting_content);
                nonTargetMeetingContentDialog.setPositiveButton(R.string.ok, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int whichButton) {
                        nonTargetMeetingContentDialog.dismiss();
                    }
                });
                nonTargetMeetingContentDialog.show();
            }
        });
    }

    /**　
     * ボタンイベント設定
     */
    private void setOnButtonEvent() {
        mDashboardHomeButton.setClickable(false);
        dashboardLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                backToHome("dashboard");
            }
        });
        // 作業のホーム画面へ
        mOperationHomeButton.setClickable(false);
        operationLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                backToHome("operationList");
            }
        });

        // 一括保存
        mAllSaveButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                final List<CategoryContentDto> listItem = mOperationRelatedContentSectionAdapter.getListItem();
                final List<ContentDto> downloadList = new ArrayList<>();
                new AsyncTask<Void, ContentDto, Void>() {
                    @Override
                    protected Void doInBackground(Void... params) {
                        for (CategoryContentDto categoryContentDto : listItem) {
                            for (ContentDto contentDto : categoryContentDto.contentDtoArray){
                                if (!(contentDto.downloadedFlg && !contentDto.updatedFlg)) {
                                    if (contentValidCheckAndShowMessage(contentDto.contentId, MessageType.TYPE_SHOW_ALERT) == ContentCheckResultType.SUCCESS) {
                                        downloadList.add(contentDto);
                                    }
                                }
                            }
                        }
                        return null;
                    }

                    @Override
                    protected void onPostExecute(Void result) {
                        new AsyncTask<Void, ContentDto, Void>() {
                            @Override
                            protected Void doInBackground(Void... params) {
                                for (ContentDto contentDto : downloadList) {
                                    Logger.i(TAG, "downloading content=" + contentDto.contentName);
                                    contentValidCheckAndDownload(contentDto.contentId);
                                }
                                return null;
                            }
                        }.execute();
                    }
                }.execute();
            }
        });

        // 簡易帳票印刷ボタン
        mQuickReportPrintButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showPrintTargetSelect();
            }
        });
    }

    /**
     * 資料の削除ダイアログ表示
     * @param contentDto 資料情報
     */
    public void showContentDeleteDialog(final ContentDto contentDto) {
        ABookAlertDialog contentsDeleteDialog = AlertDialogUtil.deleteContentAlertDialog(this);
        contentsDeleteDialog.setNegativeButton(R.string.cancel, null);
        contentsDeleteDialog.setPositiveButton(R.string.confirm, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                if (contentDelete(contentDto)) {
                    contentDto.downloadedFlg = false;
                    contentDto.downloadingFlg = false;

                    updateViewStatus(contentDto);
                    updateViewSaveAll();
                }
            }
        });
        showAlertDialog(contentsDeleteDialog);
    }

    /**
     * 作業一覧へ戻る
     */
    private void backToHome(String activeTab) {
        Intent intent = new Intent();
        intent.setClass(OperationRelatedContentActivity.this, OperationListActivity.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_SINGLE_TOP);
        intent.putExtra(AppDefType.ChatPushMessageKey.baseActivityName, OperationRelatedContentActivity.class.getName());
        if (activeTab != null && activeTab.length() > 0) {
            intent.putExtra("activeTab", activeTab);
        }
        // 左へ移動しながら戻る
        startActivity(intent, NaviConsts.Left);
    }

    public void showCancelDownloadDialog(final ContentDto contentDto) {
        // リソースパターンの適用
        ABookAlertDialog cancelDownloadDialog = AlertDialogUtil.createAlertDialog(this,
                PatternStringUtil.patternToInt(getApplicationContext(),
                        R.string.cancel,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)),
                PatternStringUtil.patternToInt(getApplicationContext(),
                        R.string.msg_cancel_download,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
        cancelDownloadDialog.setNegativeButton(R.string.cancel, null);
        cancelDownloadDialog.setPositiveButton(R.string.confirm, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                contentDownloadCancel(contentDto);
                updateViewStatus(contentDto);
            }
        });
        showAlertDialog(cancelDownloadDialog);
    }

    /**
     * 簡易帳票印刷対象選択画面表示
     */
    private void showPrintTargetSelect() {
        if (!ABVEnvironment.getInstance().networkAdapter.isNetworkConnected()) {
            showDisConnectNetworkDialog();
            return;
        }
        Intent intent = new Intent();
        intent.setClass(OperationRelatedContentActivity.this, OnlineHTMLWebViewActivity.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
        intent.putExtra("LINKURL", AcmsApis.getApiUrl(ABVEnvironment.getInstance().acmsAddress, ABVDataCache.getInstance().getUrlPath(), AcmsApis.ApiQuickReportSearch));
        startActivity(intent, NaviConsts.Right);
    }

    /**
     * インターネットが繋がってない場合のダイアログ表示
     */
    private void showDisConnectNetworkDialog() {
        handler.post(new Runnable() {
            @Override
            public void run() {
                // ヘッダーの新着更新処理を完了にさせる
                stopUpdateAnimation();
                final ABookAlertDialog messageDialog = AlertDialogUtil.createAlertDialog(OperationRelatedContentActivity.this, R.string.app_name);
                messageDialog.setMessage(getString(R.string.msg_network_offline));
                messageDialog.setPositiveButton(R.string.confirm, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int whichButton) {
                        messageDialog.dismiss();
                    }
                });
                messageDialog.show();
            }
        });
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            Logger.d(TAG, "onKeyUp.Back");
            // 端末の戻るボタン処理
            if (isCollaboration) {
                return true;
            }
            backToHome("");
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    private void updateViewStatus(ContentDto contentDto) {
        final ContentDto updatedContentDto = contentDto;
        handler.post(new Runnable() {
            @Override
            public void run() {
                mOperationRelatedContentSectionAdapter.updateDownloadView(updatedContentDto);
            }
        });
    }

    private void updateViewSaveAll() {
        handler.post(new Runnable() {
            @Override
            public void run() {
                final List<CategoryContentDto> listItem = mOperationRelatedContentSectionAdapter.getListItem();
                int visible = View.GONE;
                for (CategoryContentDto categoryContentDto : listItem) {
                    for (ContentDto dto : categoryContentDto.contentDtoArray) {
                        if (!(dto.downloadedFlg && !dto.updatedFlg)) {
                            visible = View.VISIBLE;
                            break;
                        }
                    }
                }
                if (isCollaboration) {
                    mAllSaveButton.setVisibility(isCollaborationOwner ? visible : View.GONE);
                } else {
                    mAllSaveButton.setVisibility(visible);
                }
            }
        });
    }

   public void refreshCollaborationUI() {
       if (isCollaboration) {
           activityHandlingHelper.removeContentViewActivity(activityHandlingHelper.getContentViewActivity());
           hideBottomToolbar();
           if (isCollaborationOwner) {
               hideWaitOwnerSelect();
               showContentList();
               mAllSaveButton.setVisibility(View.VISIBLE);
           } else {
               showWaitOwnerSelect();
               hideContentList();
               mAllSaveButton.setVisibility(View.GONE);
           }
       } else {
           hideWaitOwnerSelect();
           showBottomToolbar();
           showContentList();
           mAllSaveButton.setVisibility(View.VISIBLE);
       }
   }

    @Override
    public void onResume() {
        Logger.i(TAG, "onResume:start");
        updateCollaborationInfo();
        refreshCollaborationUI();
        super.onResume();
        if(goChatRoom(getIntent(), ChatWebViewActivity.class.getName(), OperationRelatedContentActivity.class.getName())) {
            return;
        }
        showOperationRelatedContentList();
    }

    @Override
    protected void onNewIntent(Intent intent) {
        updateCollaborationInfo();
        refreshCollaborationUI();
        super.onNewIntent(intent);
    }

    // 設定画面へ遷移
    public void onClickSetting(View v) {
        showSetting();
    }

    public void showWaitOwnerSelect() {
        if (mWaitOwnerTextView != null) {
            mWaitOwnerTextView.setVisibility(View.VISIBLE);
            return;
        }
        Display display = getWindowManager().getDefaultDisplay();
        DisplayMetrics outMetrics = new DisplayMetrics ();
        display.getMetrics(outMetrics);
        LinearLayout container = (LinearLayout) findViewById(R.id.related_content_third_linear);
        mWaitOwnerTextView = new TextView(this);
        mWaitOwnerTextView.setText(getString(R.string.msg_wait_for_host));
        mWaitOwnerTextView.setGravity(Gravity.CENTER);
        mWaitOwnerTextView.setTextAlignment(View.TEXT_ALIGNMENT_CENTER);
        LinearLayout mainLayout = (LinearLayout) findViewById(R.id.related_content_main_linear);
        mWaitOwnerTextView.setHeight((int) (outMetrics.heightPixels / 2));
        mWaitOwnerTextView.setTextSize(20);
        mWaitOwnerTextView.setTextColor(Color.BLACK);
        container.addView(mWaitOwnerTextView);
        mWaitOwnerTextView.setVisibility(View.VISIBLE);
    }

    public void hideWaitOwnerSelect() {
        if (mWaitOwnerTextView != null) {
            mWaitOwnerTextView.setVisibility(View.GONE);
        }
    }
    public void updateCollaborationInfo() {
        isCollaboration = meetingManager.isCollaboration();
        isCollaborationOwner = meetingManager.isCollaboration() && meetingManager.isOwner();
    }

    @Override
    public void showAlertDialog(AlertDialog alertDialog) {
        super.showAlertDialog(alertDialog);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);

        if (requestCode == ABookCommConstants.PUSH_MESSAGE_DLG_REQUEST_CODE) {
            if (resultCode == ABookCommConstants.PUSH_MESSAGE_DLG_RESULT.OK) {
                finish();
                goChatRoom(intent, ChatWebViewActivity.class.getName(), getClass().getName());
            }
            return;
        }
    }
}
