package jp.agentec.abook.abv.ui.home.adapter;

import java.util.ArrayList;

import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.launcher.android.R;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;

public class HierarchyOperationGroupListAdapter extends BaseAdapter {

	private static LayoutInflater mInflater = null;
	private ArrayList<String> mNameList = new ArrayList<>();
	private boolean[] mHaveChildFlags;
	private int[] mOperationCounts;
	
	public HierarchyOperationGroupListAdapter(Context context, ArrayList<String> nameList, boolean[] haveChildFlags, int[] operationCounts) {
		mInflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		mNameList = nameList;
		mHaveChildFlags = haveChildFlags;
		mOperationCounts = operationCounts;
	}
	
	@Override
	public int getCount() {
		return mNameList.size();
	}

	@Override
	public Object getItem(int position) {
		return mNameList.get(position);
	}

	@Override
	public long getItemId(int position) {
		return position;
	}
	
	public void remove(int position) {
		mNameList.remove(position);
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		ViewHolder holder;
		if (null == convertView) {
			convertView = mInflater.inflate(R.layout.item_popup_list_item, null);
			holder = new ViewHolder();
			holder.title = (TextView) convertView.findViewById(R.id.itemText);
			holder.nextLevel = (ImageView) convertView.findViewById(R.id.nextLevel);
			holder.itemCount = (TextView) convertView.findViewById(R.id.itemCountText);
			
			convertView.setTag(holder);
		} else {
			holder = (ViewHolder) convertView.getTag();
		}
		// タイトル
		holder.title.setText((String)getItem(position));
		// 子作業種別がある場合、「>」を表示
		if (mHaveChildFlags[position]) {
			holder.nextLevel.setVisibility(View.VISIBLE);
		} else {
			holder.nextLevel.setVisibility(View.INVISIBLE);
		}
		// 作業数
		holder.itemCount.setText("(" + mOperationCounts[position] + ")");

		return convertView;
	}

	static class ViewHolder {
		TextView title;
		ImageView nextLevel;
		TextView itemCount;
	}
}
