/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.model.layer;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.LongSparseArray;
import java.util.ArrayList;
import java.util.List;
import oz.lottie.L;
import oz.lottie.LottieComposition;
import oz.lottie.LottieDrawable;
import oz.lottie.LottieProperty;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation;
import oz.lottie.animation.keyframe.ValueCallbackKeyframeAnimation;
import oz.lottie.model.KeyPath;
import oz.lottie.model.animatable.AnimatableFloatValue;
import oz.lottie.model.layer.BaseLayer;
import oz.lottie.model.layer.Layer;
import oz.lottie.model.layer.ShapeLayer;
import oz.lottie.utils.Utils;
import oz.lottie.value.LottieValueCallback;

public class CompositionLayer
extends BaseLayer {
    private BaseKeyframeAnimation timeRemapping;
    private final List layers = new ArrayList();
    private final RectF rect = new RectF();
    private final RectF newClipRect = new RectF();
    private Paint layerPaint = new Paint();
    private Boolean hasMatte;
    private Boolean hasMasks;

    public CompositionLayer(LottieDrawable lottieDrawable, Layer layer, List list, LottieComposition lottieComposition) {
        super(lottieDrawable, layer);
        AnimatableFloatValue animatableFloatValue = layer.getTimeRemapping();
        if (animatableFloatValue != null) {
            this.timeRemapping = animatableFloatValue.createAnimation();
            this.addAnimation(this.timeRemapping);
            this.timeRemapping.addUpdateListener(this);
        } else {
            this.timeRemapping = null;
        }
        LongSparseArray longSparseArray = new LongSparseArray(lottieComposition.getLayers().size());
        BaseLayer baseLayer = null;
        int n = list.size() - 1;
        while (n >= 0) {
            Layer layer2 = (Layer)list.get(n);
            BaseLayer baseLayer2 = BaseLayer.forModel(layer2, lottieDrawable, lottieComposition);
            if (baseLayer2 != null) {
                longSparseArray.put(baseLayer2.getLayerModel().getId(), (Object)baseLayer2);
                if (baseLayer != null) {
                    baseLayer.setMatteLayer(baseLayer2);
                    baseLayer = null;
                } else {
                    this.layers.add(0, baseLayer2);
                    switch (layer2.getMatteType()) {
                        case ADD: 
                        case INVERT: {
                            baseLayer = baseLayer2;
                        }
                    }
                }
            }
            --n;
        }
        n = 0;
        while (n < longSparseArray.size()) {
            BaseLayer baseLayer3;
            long l = longSparseArray.keyAt(n);
            BaseLayer baseLayer4 = (BaseLayer)longSparseArray.get(l);
            if (baseLayer4 != null && (baseLayer3 = (BaseLayer)longSparseArray.get(baseLayer4.getLayerModel().getParentId())) != null) {
                baseLayer4.setParentLayer(baseLayer3);
            }
            ++n;
        }
    }

    @Override
    void drawLayer(Canvas canvas, Matrix matrix, int n) {
        boolean bl;
        L.beginSection("CompositionLayer#draw");
        this.newClipRect.set(0.0f, 0.0f, (float)this.layerModel.getPreCompWidth(), (float)this.layerModel.getPreCompHeight());
        matrix.mapRect(this.newClipRect);
        boolean bl2 = bl = this.lottieDrawable.isApplyingOpacityToLayersEnabled() && this.layers.size() > 1 && n != 255;
        if (bl) {
            this.layerPaint.setAlpha(n);
            Utils.saveLayerCompat(canvas, this.newClipRect, this.layerPaint);
        } else {
            canvas.save();
        }
        int n2 = bl ? 255 : n;
        int n3 = this.layers.size() - 1;
        while (n3 >= 0) {
            boolean bl3 = true;
            if (!this.newClipRect.isEmpty()) {
                bl3 = canvas.clipRect(this.newClipRect);
            }
            if (bl3) {
                BaseLayer baseLayer = (BaseLayer)this.layers.get(n3);
                baseLayer.draw(canvas, matrix, n2);
            }
            --n3;
        }
        canvas.restore();
        L.endSection("CompositionLayer#draw");
    }

    @Override
    public void getBounds(RectF rectF, Matrix matrix, boolean bl) {
        super.getBounds(rectF, matrix, bl);
        int n = this.layers.size() - 1;
        while (n >= 0) {
            this.rect.set(0.0f, 0.0f, 0.0f, 0.0f);
            ((BaseLayer)this.layers.get(n)).getBounds(this.rect, this.boundsMatrix, true);
            rectF.union(this.rect);
            --n;
        }
    }

    @Override
    public void setProgress(float f2) {
        super.setProgress(f2);
        if (this.timeRemapping != null) {
            float f3 = this.lottieDrawable.getComposition().getDurationFrames() + 0.01f;
            float f4 = this.layerModel.getComposition().getStartFrame();
            float f5 = ((Float)this.timeRemapping.getValue()).floatValue() * this.layerModel.getComposition().getFrameRate() - f4;
            f2 = f5 / f3;
        }
        if (this.layerModel.getTimeStretch() != 0.0f) {
            f2 /= this.layerModel.getTimeStretch();
        }
        if (this.timeRemapping == null) {
            f2 -= this.layerModel.getStartProgress();
        }
        int n = this.layers.size() - 1;
        while (n >= 0) {
            ((BaseLayer)this.layers.get(n)).setProgress(f2);
            --n;
        }
    }

    public boolean hasMasks() {
        if (this.hasMasks == null) {
            int n = this.layers.size() - 1;
            while (n >= 0) {
                BaseLayer baseLayer = (BaseLayer)this.layers.get(n);
                if (baseLayer instanceof ShapeLayer) {
                    if (baseLayer.hasMasksOnThisLayer()) {
                        this.hasMasks = true;
                        return true;
                    }
                } else if (baseLayer instanceof CompositionLayer && ((CompositionLayer)baseLayer).hasMasks()) {
                    this.hasMasks = true;
                    return true;
                }
                --n;
            }
            this.hasMasks = false;
        }
        return this.hasMasks;
    }

    public boolean hasMatte() {
        if (this.hasMatte == null) {
            if (this.hasMatteOnThisLayer()) {
                this.hasMatte = true;
                return true;
            }
            int n = this.layers.size() - 1;
            while (n >= 0) {
                if (((BaseLayer)this.layers.get(n)).hasMatteOnThisLayer()) {
                    this.hasMatte = true;
                    return true;
                }
                --n;
            }
            this.hasMatte = false;
        }
        return this.hasMatte;
    }

    @Override
    protected void resolveChildKeyPath(KeyPath keyPath, int n, List list, KeyPath keyPath2) {
        int n2 = 0;
        while (n2 < this.layers.size()) {
            ((BaseLayer)this.layers.get(n2)).resolveKeyPath(keyPath, n, list, keyPath2);
            ++n2;
        }
    }

    @Override
    public void addValueCallback(Object object, LottieValueCallback lottieValueCallback) {
        super.addValueCallback(object, lottieValueCallback);
        if (object == LottieProperty.TIME_REMAP) {
            if (lottieValueCallback == null) {
                this.timeRemapping = null;
            } else {
                this.timeRemapping = new ValueCallbackKeyframeAnimation(lottieValueCallback);
                this.addAnimation(this.timeRemapping);
            }
        }
    }
}

