/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.parser;

import android.graphics.Rect;
import android.util.LongSparseArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oz.lottie.LottieComposition;
import oz.lottie.LottieImageAsset;
import oz.lottie.custom.SparseArrayCompat;
import oz.lottie.model.Font;
import oz.lottie.model.FontCharacter;
import oz.lottie.model.Marker;
import oz.lottie.model.layer.Layer;
import oz.lottie.model.layer.Layer$LayerType;
import oz.lottie.parser.FontCharacterParser;
import oz.lottie.parser.FontParser;
import oz.lottie.parser.LayerParser;
import oz.lottie.parser.moshi.JsonReader;
import oz.lottie.parser.moshi.JsonReader$Options;
import oz.lottie.utils.Logger;
import oz.lottie.utils.Utils;

public class LottieCompositionMoshiParser {
    private static final JsonReader$Options NAMES = JsonReader$Options.of("w", "h", "ip", "op", "fr", "v", "layers", "assets", "fonts", "chars", "markers");
    static JsonReader$Options ASSETS_NAMES = JsonReader$Options.of("id", "layers", "w", "h", "p", "u");
    private static final JsonReader$Options FONT_NAMES = JsonReader$Options.of("list");
    private static final JsonReader$Options MARKER_NAMES = JsonReader$Options.of("cm", "tm", "dr");

    public static LottieComposition parse(JsonReader jsonReader) {
        float f2 = Utils.dpScale();
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        LongSparseArray longSparseArray = new LongSparseArray();
        ArrayList arrayList = new ArrayList();
        int n = 0;
        int n2 = 0;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        ArrayList arrayList2 = new ArrayList();
        SparseArrayCompat sparseArrayCompat = new SparseArrayCompat();
        LottieComposition lottieComposition = new LottieComposition();
        jsonReader.beginObject();
        block13: while (jsonReader.hasNext()) {
            switch (jsonReader.selectName(NAMES)) {
                case 0: {
                    n = jsonReader.nextInt();
                    break;
                }
                case 1: {
                    n2 = jsonReader.nextInt();
                    break;
                }
                case 2: {
                    f3 = (float)jsonReader.nextDouble();
                    break;
                }
                case 3: {
                    f4 = (float)jsonReader.nextDouble() - 0.01f;
                    break;
                }
                case 4: {
                    f5 = (float)jsonReader.nextDouble();
                    break;
                }
                case 5: {
                    String string = jsonReader.nextString();
                    String[] stringArray = string.split("\\.");
                    int n3 = Integer.parseInt(stringArray[0]);
                    int n4 = Integer.parseInt(stringArray[1]);
                    int n5 = Integer.parseInt(stringArray[2]);
                    if (Utils.isAtLeastVersion(n3, n4, n5, 4, 4, 0)) continue block13;
                    lottieComposition.addWarning("Lottie only supports bodymovin >= 4.4.0");
                    break;
                }
                case 6: {
                    LottieCompositionMoshiParser.parseLayers(jsonReader, lottieComposition, arrayList, longSparseArray);
                    break;
                }
                case 7: {
                    LottieCompositionMoshiParser.parseAssets(jsonReader, lottieComposition, hashMap, hashMap2);
                    break;
                }
                case 8: {
                    LottieCompositionMoshiParser.parseFonts(jsonReader, hashMap3);
                    break;
                }
                case 9: {
                    LottieCompositionMoshiParser.parseChars(jsonReader, lottieComposition, sparseArrayCompat);
                    break;
                }
                case 10: {
                    LottieCompositionMoshiParser.parseMarkers(jsonReader, lottieComposition, arrayList2);
                    break;
                }
                default: {
                    jsonReader.skipName();
                    jsonReader.skipValue();
                }
            }
        }
        int n6 = (int)((float)n * f2);
        int n7 = (int)((float)n2 * f2);
        Rect rect = new Rect(0, 0, n6, n7);
        lottieComposition.init(rect, f3, f4, f5, arrayList, longSparseArray, hashMap, hashMap2, sparseArrayCompat, hashMap3, arrayList2);
        return lottieComposition;
    }

    private static void parseLayers(JsonReader jsonReader, LottieComposition lottieComposition, List list, LongSparseArray longSparseArray) {
        int n = 0;
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            Layer layer = LayerParser.parse(jsonReader, lottieComposition);
            if (layer.getLayerType() == Layer$LayerType.IMAGE) {
                ++n;
            }
            list.add(layer);
            longSparseArray.put(layer.getId(), (Object)layer);
            if (n <= 4) continue;
            Logger.warning("You have " + n + " images. Lottie should primarily be " + "used with shapes. If you are using Adobe Illustrator, convert the Illustrator layers" + " to shape layers.");
        }
        jsonReader.endArray();
    }

    private static void parseAssets(JsonReader jsonReader, LottieComposition lottieComposition, Map map, Map map2) {
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            Object object;
            String string = null;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            LongSparseArray longSparseArray = new LongSparseArray();
            int n = 0;
            int n2 = 0;
            String string2 = null;
            String string3 = null;
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                switch (jsonReader.selectName(ASSETS_NAMES)) {
                    case 0: {
                        string = jsonReader.nextString();
                        break;
                    }
                    case 1: {
                        jsonReader.beginArray();
                        while (jsonReader.hasNext()) {
                            object = LayerParser.parse(jsonReader, lottieComposition);
                            longSparseArray.put(((Layer)object).getId(), object);
                            arrayList.add(object);
                        }
                        jsonReader.endArray();
                        break;
                    }
                    case 2: {
                        n = jsonReader.nextInt();
                        break;
                    }
                    case 3: {
                        n2 = jsonReader.nextInt();
                        break;
                    }
                    case 4: {
                        string2 = jsonReader.nextString();
                        break;
                    }
                    case 5: {
                        string3 = jsonReader.nextString();
                        break;
                    }
                    default: {
                        jsonReader.skipName();
                        jsonReader.skipValue();
                    }
                }
            }
            jsonReader.endObject();
            if (string2 != null) {
                object = new LottieImageAsset(n, n2, string, string2, string3);
                map2.put(((LottieImageAsset)object).getId(), object);
                continue;
            }
            map.put(string, arrayList);
        }
        jsonReader.endArray();
    }

    private static void parseFonts(JsonReader jsonReader, Map map) {
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            switch (jsonReader.selectName(FONT_NAMES)) {
                case 0: {
                    jsonReader.beginArray();
                    while (jsonReader.hasNext()) {
                        Font font = FontParser.parse(jsonReader);
                        map.put(font.getName(), font);
                    }
                    jsonReader.endArray();
                    break;
                }
                default: {
                    jsonReader.skipName();
                    jsonReader.skipValue();
                }
            }
        }
        jsonReader.endObject();
    }

    private static void parseChars(JsonReader jsonReader, LottieComposition lottieComposition, SparseArrayCompat sparseArrayCompat) {
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            FontCharacter fontCharacter = FontCharacterParser.parse(jsonReader, lottieComposition);
            sparseArrayCompat.put(fontCharacter.hashCode(), fontCharacter);
        }
        jsonReader.endArray();
    }

    private static void parseMarkers(JsonReader jsonReader, LottieComposition lottieComposition, List list) {
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            String string = null;
            float f2 = 0.0f;
            float f3 = 0.0f;
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                switch (jsonReader.selectName(MARKER_NAMES)) {
                    case 0: {
                        string = jsonReader.nextString();
                        break;
                    }
                    case 1: {
                        f2 = (float)jsonReader.nextDouble();
                        break;
                    }
                    case 2: {
                        f3 = (float)jsonReader.nextDouble();
                        break;
                    }
                    default: {
                        jsonReader.skipName();
                        jsonReader.skipValue();
                    }
                }
            }
            jsonReader.endObject();
            list.add(new Marker(string, f2, f3));
        }
        jsonReader.endArray();
    }
}

