/*
 * Decompiled with CFR 0.152.
 */
package oz.util;

import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import oz.util.IHttpClient;

public class HttpGeneralClient
implements IHttpClient {
    private static final int DEF_TIMEOUT = 5000;
    private HttpURLConnection conn = null;
    private InputStream input = null;
    private String returnMsg = "";

    public void close() {
        if (this.conn != null) {
            this.conn.disconnect();
        }
    }

    public int readBytes(byte[] byArray) {
        if (this.conn == null || this.input == null) {
            return -999;
        }
        try {
            return this.input.read(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            Log.e((String)"OZViewer", (String)("readByte error : " + iOException.getLocalizedMessage()), (Throwable)iOException);
            return -999;
        }
    }

    private int getConnectionTimeout(int n) {
        int n2 = -1;
        String string = System.getProperty("OZ_HTTP_REQUEST_TIMEOUT");
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (n2 >= 0) {
            return n2;
        }
        return n;
    }

    public boolean Download(String string) {
        try {
            URL uRL = new URL(string);
            this.conn = (HttpURLConnection)uRL.openConnection();
            if (this.conn != null) {
                int n = this.getConnectionTimeout(5000);
                this.conn.setConnectTimeout(n);
                this.conn.setUseCaches(false);
                if (this.conn.getResponseCode() == 200) {
                    this.input = this.conn.getInputStream();
                }
                return true;
            }
        }
        catch (Exception exception) {
            Log.d((String)"OZViewer", (String)"error download", (Throwable)exception);
        }
        return false;
    }

    public boolean DoGet(String string) {
        try {
            int n = this.getConnectionTimeout(5000);
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setConnectTimeout(n);
            httpURLConnection.setReadTimeout(n);
            return this.getResponseData(httpURLConnection);
        }
        catch (Throwable throwable) {
            this.returnMsg = throwable.getLocalizedMessage();
            return false;
        }
    }

    public boolean DoPost(String string, String string2) {
        try {
            int n = this.getConnectionTimeout(5000);
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setConnectTimeout(n);
            httpURLConnection.setReadTimeout(n);
            httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(httpURLConnection.getOutputStream());
            outputStreamWriter.write(string2);
            outputStreamWriter.flush();
            outputStreamWriter.close();
            return this.getResponseData(httpURLConnection);
        }
        catch (Throwable throwable) {
            this.returnMsg = throwable.getLocalizedMessage();
            return false;
        }
    }

    public String GetResponseBodyAsString() {
        return this.returnMsg;
    }

    private boolean getResponseData(HttpURLConnection httpURLConnection) {
        int n = httpURLConnection.getResponseCode();
        if (n == 200) {
            this.returnMsg = this.readBuffer(httpURLConnection.getInputStream()).toString();
            return true;
        }
        this.returnMsg = "Http Connection Error! ResponseCode : " + n + "\n" + this.readBuffer(httpURLConnection.getErrorStream()).toString();
        return false;
    }

    private StringBuffer readBuffer(InputStream inputStream) {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string);
        }
        bufferedReader.close();
        return stringBuffer;
    }
}

