/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.aztec.encoder;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import oz.util.barcode.aztec.encoder.HighLevelEncoder$1;
import oz.util.barcode.aztec.encoder.State;
import oz.util.barcode.common.BitArray;

public final class HighLevelEncoder {
    static final String[] MODE_NAMES = new String[]{"UPPER", "LOWER", "DIGIT", "MIXED", "PUNCT"};
    static final int MODE_UPPER = 0;
    static final int MODE_LOWER = 1;
    static final int MODE_DIGIT = 2;
    static final int MODE_MIXED = 3;
    static final int MODE_PUNCT = 4;
    static final int[][] LATCH_TABLE;
    private static final int[][] CHAR_MAP;
    static final int[][] SHIFT_TABLE;
    private final byte[] text;

    static {
        int[][] nArrayArray = new int[5][];
        int[] nArray = new int[5];
        nArray[1] = 327708;
        nArray[2] = 327710;
        nArray[3] = 327709;
        nArray[4] = 656318;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[5];
        nArray2[0] = 590318;
        nArray2[2] = 327710;
        nArray2[3] = 327709;
        nArray2[4] = 656318;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[5];
        nArray3[0] = 262158;
        nArray3[1] = 590300;
        nArray3[3] = 590301;
        nArray3[4] = 932798;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[5];
        nArray4[0] = 327709;
        nArray4[1] = 327708;
        nArray4[2] = 656318;
        nArray4[4] = 327710;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[5];
        nArray5[0] = 327711;
        nArray5[1] = 656380;
        nArray5[2] = 656382;
        nArray5[3] = 656381;
        nArrayArray[4] = nArray5;
        LATCH_TABLE = nArrayArray;
        CHAR_MAP = new int[5][256];
        HighLevelEncoder.CHAR_MAP[0][32] = 1;
        int n = 65;
        while (n <= 90) {
            HighLevelEncoder.CHAR_MAP[0][n] = n - 65 + 2;
            ++n;
        }
        HighLevelEncoder.CHAR_MAP[1][32] = 1;
        n = 97;
        while (n <= 122) {
            HighLevelEncoder.CHAR_MAP[1][n] = n - 97 + 2;
            ++n;
        }
        HighLevelEncoder.CHAR_MAP[2][32] = 1;
        n = 48;
        while (n <= 57) {
            HighLevelEncoder.CHAR_MAP[2][n] = n - 48 + 2;
            ++n;
        }
        HighLevelEncoder.CHAR_MAP[2][44] = 12;
        HighLevelEncoder.CHAR_MAP[2][46] = 13;
        int[] nArray6 = new int[28];
        nArray6[1] = 32;
        nArray6[2] = 1;
        nArray6[3] = 2;
        nArray6[4] = 3;
        nArray6[5] = 4;
        nArray6[6] = 5;
        nArray6[7] = 6;
        nArray6[8] = 7;
        nArray6[9] = 8;
        nArray6[10] = 9;
        nArray6[11] = 10;
        nArray6[12] = 11;
        nArray6[13] = 12;
        nArray6[14] = 13;
        nArray6[15] = 27;
        nArray6[16] = 28;
        nArray6[17] = 29;
        nArray6[18] = 30;
        nArray6[19] = 31;
        nArray6[20] = 64;
        nArray6[21] = 92;
        nArray6[22] = 94;
        nArray6[23] = 95;
        nArray6[24] = 96;
        nArray6[25] = 124;
        nArray6[26] = 126;
        nArray6[27] = 127;
        int[] nArray7 = nArray6;
        int n2 = 0;
        while (n2 < nArray7.length) {
            HighLevelEncoder.CHAR_MAP[3][nArray7[n2]] = n2;
            ++n2;
        }
        int[] nArray8 = new int[31];
        nArray8[1] = 13;
        nArray8[6] = 33;
        nArray8[7] = 39;
        nArray8[8] = 35;
        nArray8[9] = 36;
        nArray8[10] = 37;
        nArray8[11] = 38;
        nArray8[12] = 39;
        nArray8[13] = 40;
        nArray8[14] = 41;
        nArray8[15] = 42;
        nArray8[16] = 43;
        nArray8[17] = 44;
        nArray8[18] = 45;
        nArray8[19] = 46;
        nArray8[20] = 47;
        nArray8[21] = 58;
        nArray8[22] = 59;
        nArray8[23] = 60;
        nArray8[24] = 61;
        nArray8[25] = 62;
        nArray8[26] = 63;
        nArray8[27] = 91;
        nArray8[28] = 93;
        nArray8[29] = 123;
        nArray8[30] = 125;
        int[] nArray9 = nArray8;
        int n3 = 0;
        while (n3 < nArray9.length) {
            if (nArray9[n3] > 0) {
                HighLevelEncoder.CHAR_MAP[4][nArray9[n3]] = n3;
            }
            ++n3;
        }
        int[][] nArray10 = SHIFT_TABLE = new int[6][6];
        n3 = SHIFT_TABLE.length;
        int n4 = 0;
        while (n4 < n3) {
            nArray7 = nArray10[n4];
            Arrays.fill(nArray7, -1);
            ++n4;
        }
        HighLevelEncoder.SHIFT_TABLE[0][4] = 0;
        HighLevelEncoder.SHIFT_TABLE[1][4] = 0;
        HighLevelEncoder.SHIFT_TABLE[1][0] = 28;
        HighLevelEncoder.SHIFT_TABLE[3][4] = 0;
        HighLevelEncoder.SHIFT_TABLE[2][4] = 0;
        HighLevelEncoder.SHIFT_TABLE[2][0] = 15;
    }

    public HighLevelEncoder(byte[] byArray) {
        this.text = byArray;
    }

    public BitArray encode() {
        Collection<State> collection = Collections.singletonList(State.INITIAL_STATE);
        int n = 0;
        while (n < this.text.length) {
            int n2;
            byte by = n + 1 < this.text.length ? this.text[n + 1] : (byte)0;
            switch (this.text[n]) {
                case 13: {
                    n2 = by == 10 ? 2 : 0;
                    break;
                }
                case 46: {
                    n2 = by == 32 ? 3 : 0;
                    break;
                }
                case 44: {
                    n2 = by == 32 ? 4 : 0;
                    break;
                }
                case 58: {
                    n2 = by == 32 ? 5 : 0;
                    break;
                }
                default: {
                    n2 = 0;
                }
            }
            if (n2 > 0) {
                collection = HighLevelEncoder.updateStateListForPair(collection, n, n2);
                ++n;
            } else {
                collection = this.updateStateListForChar(collection, n);
            }
            ++n;
        }
        State state = Collections.min(collection, new HighLevelEncoder$1(this));
        return state.toBitArray(this.text);
    }

    private Collection updateStateListForChar(Iterable iterable, int n) {
        LinkedList linkedList = new LinkedList();
        for (State state : iterable) {
            this.updateStateForChar(state, n, linkedList);
        }
        return HighLevelEncoder.simplifyStates(linkedList);
    }

    private void updateStateForChar(State state, int n, Collection collection) {
        char c2 = (char)(this.text[n] & 0xFF);
        boolean bl = CHAR_MAP[state.getMode()][c2] > 0;
        State state2 = null;
        int n2 = 0;
        while (n2 <= 4) {
            int n3 = CHAR_MAP[n2][c2];
            if (n3 > 0) {
                State state3;
                if (state2 == null) {
                    state2 = state.endBinaryShift(n);
                }
                if (!bl || n2 == state.getMode() || n2 == 2) {
                    state3 = state2.latchAndAppend(n2, n3);
                    collection.add(state3);
                }
                if (!bl && SHIFT_TABLE[state.getMode()][n2] >= 0) {
                    state3 = state2.shiftAndAppend(n2, n3);
                    collection.add(state3);
                }
            }
            ++n2;
        }
        if (state.getBinaryShiftByteCount() > 0 || CHAR_MAP[state.getMode()][c2] == 0) {
            State state4 = state.addBinaryShiftChar(n);
            collection.add(state4);
        }
    }

    private static Collection updateStateListForPair(Iterable iterable, int n, int n2) {
        LinkedList linkedList = new LinkedList();
        for (State state : iterable) {
            HighLevelEncoder.updateStateForPair(state, n, n2, linkedList);
        }
        return HighLevelEncoder.simplifyStates(linkedList);
    }

    private static void updateStateForPair(State state, int n, int n2, Collection collection) {
        State state2;
        State state3 = state.endBinaryShift(n);
        collection.add(state3.latchAndAppend(4, n2));
        if (state.getMode() != 4) {
            collection.add(state3.shiftAndAppend(4, n2));
        }
        if (n2 == 3 || n2 == 4) {
            state2 = state3.latchAndAppend(2, 16 - n2).latchAndAppend(2, 1);
            collection.add(state2);
        }
        if (state.getBinaryShiftByteCount() > 0) {
            state2 = state.addBinaryShiftChar(n).addBinaryShiftChar(n + 1);
            collection.add(state2);
        }
    }

    private static Collection simplifyStates(Iterable iterable) {
        LinkedList<State> linkedList = new LinkedList<State>();
        for (State state : iterable) {
            boolean bl = true;
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                State state2 = (State)iterator.next();
                if (state2.isBetterThanOrEqualTo(state)) {
                    bl = false;
                    break;
                }
                if (!state.isBetterThanOrEqualTo(state2)) continue;
                iterator.remove();
            }
            if (!bl) continue;
            linkedList.add(state);
        }
        return linkedList;
    }
}

