/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.datamatrix;

import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.Dimension;
import oz.util.barcode.EncodeHintType;
import oz.util.barcode.Writer;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.datamatrix.encoder.DefaultPlacement;
import oz.util.barcode.datamatrix.encoder.ErrorCorrection;
import oz.util.barcode.datamatrix.encoder.HighLevelEncoder;
import oz.util.barcode.datamatrix.encoder.SymbolInfo;
import oz.util.barcode.datamatrix.encoder.SymbolShapeHint;
import oz.util.barcode.qrcode.encoder.ByteMatrix;

public final class DataMatrixWriter
implements Writer {
    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2) {
        return this.encode(string, barcodeFormat, n, n2, null);
    }

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Map map) {
        Object object;
        Object object2;
        Object object3;
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Found empty contents");
        }
        if (barcodeFormat != BarcodeFormat.DATA_MATRIX) {
            throw new IllegalArgumentException("Can only encode DATA_MATRIX, but got " + (Object)((Object)barcodeFormat));
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Requested dimensions are too small: " + n + 'x' + n2);
        }
        Object object4 = SymbolShapeHint.FORCE_NONE;
        Object object5 = null;
        Object object6 = null;
        if (map != null) {
            object3 = (SymbolShapeHint)((Object)map.get((Object)EncodeHintType.DATA_MATRIX_SHAPE));
            if (object3 != null) {
                object4 = object3;
            }
            if ((object2 = (Dimension)map.get((Object)EncodeHintType.MIN_SIZE)) != null) {
                object5 = object2;
            }
            if ((object = (Dimension)map.get((Object)EncodeHintType.MAX_SIZE)) != null) {
                object6 = object;
            }
        }
        object3 = HighLevelEncoder.encodeHighLevel(string, object4, object5, object6);
        object2 = SymbolInfo.lookup(((String)object3).length(), object4, object5, object6, true);
        object = ErrorCorrection.encodeECC200((String)object3, (SymbolInfo)object2);
        DefaultPlacement defaultPlacement = new DefaultPlacement((CharSequence)object, ((SymbolInfo)object2).getSymbolDataWidth(), ((SymbolInfo)object2).getSymbolDataHeight());
        defaultPlacement.place();
        return DataMatrixWriter.encodeLowLevel(defaultPlacement, (SymbolInfo)object2);
    }

    private static BitMatrix encodeLowLevel(DefaultPlacement defaultPlacement, SymbolInfo symbolInfo) {
        int n = symbolInfo.getSymbolDataWidth();
        int n2 = symbolInfo.getSymbolDataHeight();
        ByteMatrix byteMatrix = new ByteMatrix(symbolInfo.getSymbolWidth(), symbolInfo.getSymbolHeight());
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5;
            int n6;
            if (n4 % symbolInfo.matrixHeight == 0) {
                n6 = 0;
                n5 = 0;
                while (n5 < symbolInfo.getSymbolWidth()) {
                    byteMatrix.set(n6, n3, n5 % 2 == 0);
                    ++n6;
                    ++n5;
                }
                ++n3;
            }
            n6 = 0;
            n5 = 0;
            while (n5 < n) {
                if (n5 % symbolInfo.matrixWidth == 0) {
                    byteMatrix.set(n6, n3, true);
                    ++n6;
                }
                byteMatrix.set(n6, n3, defaultPlacement.getBit(n5, n4));
                ++n6;
                if (n5 % symbolInfo.matrixWidth == symbolInfo.matrixWidth - 1) {
                    byteMatrix.set(n6, n3, n4 % 2 == 0);
                    ++n6;
                }
                ++n5;
            }
            ++n3;
            if (n4 % symbolInfo.matrixHeight == symbolInfo.matrixHeight - 1) {
                n6 = 0;
                n5 = 0;
                while (n5 < symbolInfo.getSymbolWidth()) {
                    byteMatrix.set(n6, n3, true);
                    ++n6;
                    ++n5;
                }
                ++n3;
            }
            ++n4;
        }
        return DataMatrixWriter.convertByteMatrixToBitMatrix(byteMatrix);
    }

    private static BitMatrix convertByteMatrixToBitMatrix(ByteMatrix byteMatrix) {
        int n = byteMatrix.getWidth();
        int n2 = byteMatrix.getHeight();
        BitMatrix bitMatrix = new BitMatrix(n, n2);
        bitMatrix.clear();
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                if (byteMatrix.get(n3, n4) == 1) {
                    bitMatrix.set(n3, n4);
                }
                ++n4;
            }
            ++n3;
        }
        return bitMatrix;
    }
}

