/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.datamatrix.encoder;

import oz.util.barcode.datamatrix.encoder.Encoder;
import oz.util.barcode.datamatrix.encoder.EncoderContext;
import oz.util.barcode.datamatrix.encoder.HighLevelEncoder;

final class Base256Encoder
implements Encoder {
    Base256Encoder() {
    }

    @Override
    public int getEncodingMode() {
        return 5;
    }

    @Override
    public void encode(EncoderContext encoderContext) {
        boolean bl;
        int n;
        char c2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\u0000');
        while (encoderContext.hasMoreCharacters()) {
            c2 = encoderContext.getCurrentChar();
            stringBuilder.append(c2);
            ++encoderContext.pos;
            n = HighLevelEncoder.lookAheadTest(encoderContext.getMessage(), encoderContext.pos, this.getEncodingMode());
            if (n == this.getEncodingMode()) continue;
            encoderContext.signalEncoderChange(n);
            break;
        }
        c2 = stringBuilder.length() - 1;
        n = 1;
        int n2 = encoderContext.getCodewordCount() + c2 + n;
        encoderContext.updateSymbolInfo(n2);
        boolean bl2 = bl = encoderContext.getSymbolInfo().getDataCapacity() - n2 > 0;
        if (encoderContext.hasMoreCharacters() || bl) {
            if (c2 <= '\u00f9') {
                stringBuilder.setCharAt(0, c2);
            } else if (c2 > '\u00f9' && c2 <= '\u0613') {
                stringBuilder.setCharAt(0, (char)(c2 / 250 + 249));
                stringBuilder.insert(1, (char)(c2 % 250));
            } else {
                throw new IllegalStateException("Message length not in valid ranges: " + c2);
            }
        }
        int n3 = 0;
        int n4 = stringBuilder.length();
        while (n3 < n4) {
            encoderContext.writeCodeword(Base256Encoder.randomize255State(stringBuilder.charAt(n3), encoderContext.getCodewordCount() + 1));
            ++n3;
        }
    }

    private static char randomize255State(char c2, int n) {
        int n2 = 149 * n % 255 + 1;
        int n3 = c2 + n2;
        if (n3 <= 255) {
            return (char)n3;
        }
        return (char)(n3 - 256);
    }
}

