/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.common.BitArray;
import oz.util.barcode.oned.UPCEANReader;

public final class EAN13Reader
extends UPCEANReader {
    static final int[] FIRST_DIGIT_ENCODINGS;
    private final int[] decodeMiddleCounters = new int[4];

    static {
        int[] nArray = new int[10];
        nArray[1] = 11;
        nArray[2] = 13;
        nArray[3] = 14;
        nArray[4] = 19;
        nArray[5] = 25;
        nArray[6] = 28;
        nArray[7] = 21;
        nArray[8] = 22;
        nArray[9] = 26;
        FIRST_DIGIT_ENCODINGS = nArray;
    }

    @Override
    protected int decodeMiddle(BitArray bitArray, int[] nArray, StringBuilder stringBuilder) {
        int n;
        int n2;
        int n3;
        int n4;
        int[] nArray2 = this.decodeMiddleCounters;
        nArray2[0] = 0;
        nArray2[1] = 0;
        nArray2[2] = 0;
        nArray2[3] = 0;
        int n5 = bitArray.getSize();
        int n6 = nArray[1];
        int n7 = 0;
        int n8 = 0;
        while (n8 < 6 && n6 < n5) {
            n4 = EAN13Reader.decodeDigit(bitArray, nArray2, n6, L_AND_G_PATTERNS);
            stringBuilder.append((char)(48 + n4 % 10));
            int[] nArray3 = nArray2;
            n3 = nArray2.length;
            n2 = 0;
            while (n2 < n3) {
                n = nArray3[n2];
                n6 += n;
                ++n2;
            }
            if (n4 >= 10) {
                n7 |= 1 << 5 - n8;
            }
            ++n8;
        }
        EAN13Reader.determineFirstDigit(stringBuilder, n7);
        int[] nArray4 = EAN13Reader.findGuardPattern(bitArray, n6, true, MIDDLE_PATTERN);
        n6 = nArray4[1];
        n4 = 0;
        while (n4 < 6 && n6 < n5) {
            n = EAN13Reader.decodeDigit(bitArray, nArray2, n6, L_PATTERNS);
            stringBuilder.append((char)(48 + n));
            int[] nArray5 = nArray2;
            int n9 = nArray2.length;
            n3 = 0;
            while (n3 < n9) {
                n2 = nArray5[n3];
                n6 += n2;
                ++n3;
            }
            ++n4;
        }
        return n6;
    }

    @Override
    BarcodeFormat getBarcodeFormat() {
        return BarcodeFormat.EAN_13;
    }

    private static void determineFirstDigit(StringBuilder stringBuilder, int n) {
        int n2 = 0;
        while (n2 < 10) {
            if (n == FIRST_DIGIT_ENCODINGS[n2]) {
                stringBuilder.insert(0, (char)(48 + n2));
                return;
            }
            ++n2;
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

