/*
 * Decompiled with CFR 0.152.
 */
package oz.util.gif;

import android.util.Log;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import oz.util.gif.GifFrame;
import oz.util.gif.GifHeader;

public class GifHeaderParser {
    public static final String TAG = "GifHeaderParser";
    static final int MIN_FRAME_DELAY = 2;
    static final int DEFAULT_FRAME_DELAY = 10;
    private static final int MAX_BLOCK_SIZE = 256;
    private final byte[] block = new byte[256];
    private ByteBuffer rawData;
    private GifHeader header;
    private int blockSize = 0;

    public GifHeaderParser setData(ByteBuffer byteBuffer) {
        this.reset();
        this.rawData = byteBuffer.asReadOnlyBuffer();
        this.rawData.position(0);
        this.rawData.order(ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public GifHeaderParser setData(byte[] byArray) {
        if (byArray != null) {
            this.setData(ByteBuffer.wrap(byArray));
        } else {
            this.rawData = null;
            if (this.header == null) {
                throw new IllegalStateException("Parse failed, check your gif data");
            }
            this.header.status = 2;
        }
        return this;
    }

    public void clear() {
        this.rawData = null;
        this.header = null;
    }

    private void reset() {
        this.rawData = null;
        Arrays.fill(this.block, (byte)0);
        this.header = new GifHeader();
        this.blockSize = 0;
    }

    public GifHeader parseHeader() {
        if (this.rawData == null) {
            throw new IllegalStateException("You must call setData() before parseHeader()");
        }
        if (this.err()) {
            return this.header;
        }
        this.readHeader();
        if (!this.err()) {
            this.readContents();
            if (this.header.frameCount < 0) {
                this.header.status = 1;
            }
        }
        return this.header;
    }

    public boolean isAnimated() {
        this.readHeader();
        if (!this.err()) {
            this.readContents(2);
        }
        return this.header.frameCount > 1;
    }

    private void readContents() {
        this.readContents(Integer.MAX_VALUE);
    }

    private void readContents(int n) {
        boolean bl = false;
        block11: while (!bl && !this.err() && this.header.frameCount <= n) {
            int n2 = this.read();
            switch (n2) {
                case 44: {
                    if (this.header.currentFrame == null) {
                        this.header.currentFrame = new GifFrame();
                    }
                    this.readBitmap();
                    continue block11;
                }
                case 33: {
                    n2 = this.read();
                    switch (n2) {
                        case 249: {
                            this.header.currentFrame = new GifFrame();
                            this.readGraphicControlExt();
                            continue block11;
                        }
                        case 255: {
                            this.readBlock();
                            String string = "";
                            for (int j = 0; j < 11; ++j) {
                                string = string + (char)this.block[j];
                            }
                            if (string.equals("NETSCAPE2.0")) {
                                this.readNetscapeExt();
                                continue block11;
                            }
                            this.skip();
                            continue block11;
                        }
                        case 254: {
                            this.skip();
                            continue block11;
                        }
                        case 1: {
                            this.skip();
                            continue block11;
                        }
                    }
                    this.skip();
                    continue block11;
                }
                case 59: {
                    bl = true;
                    continue block11;
                }
            }
            this.header.status = 1;
        }
    }

    private void readGraphicControlExt() {
        this.read();
        int n = this.read();
        this.header.currentFrame.dispose = (n & 0x1C) >> 2;
        if (this.header.currentFrame.dispose == 0) {
            this.header.currentFrame.dispose = 1;
        }
        this.header.currentFrame.transparency = (n & 1) != 0;
        int n2 = this.readShort();
        if (n2 < 2) {
            n2 = 10;
        }
        this.header.currentFrame.delay = n2 * 10;
        this.header.currentFrame.transIndex = this.read();
        this.read();
    }

    private void readBitmap() {
        this.header.currentFrame.ix = this.readShort();
        this.header.currentFrame.iy = this.readShort();
        this.header.currentFrame.iw = this.readShort();
        this.header.currentFrame.ih = this.readShort();
        int n = this.read();
        boolean bl = (n & 0x80) != 0;
        int n2 = (int)Math.pow(2.0, (n & 7) + 1);
        this.header.currentFrame.interlace = (n & 0x40) != 0;
        this.header.currentFrame.lct = (int[])(bl ? this.readColorTable(n2) : null);
        this.header.currentFrame.bufferFrameStart = this.rawData.position();
        this.skipImageData();
        if (this.err()) {
            return;
        }
        ++this.header.frameCount;
        this.header.frames.add(this.header.currentFrame);
    }

    private void readNetscapeExt() {
        do {
            this.readBlock();
            if (this.block[0] != 1) continue;
            int n = this.block[1] & 0xFF;
            int n2 = this.block[2] & 0xFF;
            this.header.loopCount = n2 << 8 | n;
            if (this.header.loopCount != 0) continue;
            this.header.loopCount = -1;
        } while (this.blockSize > 0 && !this.err());
    }

    private void readHeader() {
        String string = "";
        for (int j = 0; j < 6; ++j) {
            string = string + (char)this.read();
        }
        if (!string.startsWith("GIF")) {
            this.header.status = 1;
            return;
        }
        this.readLSD();
        if (this.header.gctFlag && !this.err()) {
            this.header.gct = this.readColorTable(this.header.gctSize);
            this.header.bgColor = this.header.gct[this.header.bgIndex];
        }
    }

    private void readLSD() {
        this.header.width = this.readShort();
        this.header.height = this.readShort();
        int n = this.read();
        this.header.gctFlag = (n & 0x80) != 0;
        this.header.gctSize = 2 << (n & 7);
        this.header.bgIndex = this.read();
        this.header.pixelAspect = this.read();
    }

    private int[] readColorTable(int n) {
        int n2 = 3 * n;
        int[] nArray = null;
        byte[] byArray = new byte[n2];
        try {
            this.rawData.get(byArray);
            nArray = new int[256];
            int n3 = 0;
            int n4 = 0;
            while (n3 < n) {
                int n5 = byArray[n4++] & 0xFF;
                int n6 = byArray[n4++] & 0xFF;
                int n7 = byArray[n4++] & 0xFF;
                nArray[n3++] = 0xFF000000 | n5 << 16 | n6 << 8 | n7;
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Format Error Reading Color Table", (Throwable)bufferUnderflowException);
            }
            this.header.status = 1;
        }
        return nArray;
    }

    private void skipImageData() {
        this.read();
        this.skip();
    }

    private void skip() {
        try {
            int n;
            do {
                n = this.read();
                this.rawData.position(this.rawData.position() + n);
            } while (n > 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private int readBlock() {
        int n;
        this.blockSize = this.read();
        if (this.blockSize > 0) {
            int n2 = 0;
            try {
                for (n = 0; n < this.blockSize; n += n2) {
                    n2 = this.blockSize - n;
                    this.rawData.get(this.block, n, n2);
                }
            }
            catch (Exception exception) {
                if (Log.isLoggable((String)TAG, (int)3)) {
                    Log.d((String)TAG, (String)("Error Reading Block n: " + n + " count: " + n2 + " blockSize: " + this.blockSize), (Throwable)exception);
                }
                this.header.status = 1;
            }
        }
        return n;
    }

    private int read() {
        int n = 0;
        try {
            n = this.rawData.get() & 0xFF;
        }
        catch (Exception exception) {
            this.header.status = 1;
        }
        return n;
    }

    private int readShort() {
        return this.rawData.getShort();
    }

    private boolean err() {
        return this.header.status != 0;
    }
}

