/*
 * Decompiled with CFR 0.152.
 */
package oz.util.view.camera;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import oz.util.view.camera.CameraView;

public class ImageViewBase
extends FrameLayout {
    protected static final int CAMERA_NOTHING = 0;
    protected static final int CAMERA_CAN_OPEN = 1;
    protected static final int CAMERA_CAN_NOT_OPEN = 2;
    protected static final int CAMERA_DIALOG_OPEN = 4;
    protected ImageView mImageView;
    protected Dialog mDialog;
    protected CameraView mCameraView;
    protected int mOpenCameraState;
    protected float mPictureRatio;
    protected boolean mIsCameraShowToolbar;
    protected boolean mIsCameraToolbarFlash;
    protected boolean mIsCameraToolbarFacing;
    protected int mFlashMode;
    protected int mFacingMode;

    public ImageViewBase(Context context) {
        super(context);
        this.setWillNotDraw(false);
        this.setPictureRatio(1.0f);
        this.mImageView = new ImageView(context);
        this.addView((View)this.mImageView);
    }

    protected void addCameraState(int n) {
        this.mOpenCameraState |= n;
    }

    protected void removeCameraState(int n) {
        this.mOpenCameraState &= ~n;
    }

    protected boolean isCameraState(int n) {
        return (this.mOpenCameraState | n) == n;
    }

    public void setPictureRatio(float f2) {
        if (f2 > 0.0f) {
            this.mPictureRatio = f2;
        }
    }

    public void setProperty(boolean bl, boolean bl2, boolean bl3, int n, int n2) {
        this.mIsCameraShowToolbar = bl;
        this.mIsCameraToolbarFlash = bl2;
        this.mIsCameraToolbarFacing = bl3;
        this.mFlashMode = n;
        this.mFacingMode = n2;
    }

    public void dismiss() {
        if (this.mDialog != null) {
            this.mDialog.dismiss();
        }
        this.mDialog = null;
    }

    public void setImageBitmap(Bitmap bitmap) {
        this.mImageView.setImageBitmap(bitmap);
    }
}

