/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.text.DecimalFormat;
import java.util.Arrays;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.view.DFCheckView;
import oz.viewer.ui.df.view.DFClearButton$Builder;
import oz.viewer.ui.df.view.DFInputCompNumber$1;
import oz.viewer.ui.df.view.DFInputCompNumber$2;
import oz.viewer.ui.df.view.DFInputCompNumber$3;
import oz.viewer.ui.df.view.DFInputCompNumber$4;
import oz.viewer.ui.df.view.DFInputCompNumber$DFNumberInterface;
import oz.viewer.ui.df.view.DFInputCompView;
import oz.viewer.ui.df.view.DFSelectItemView;
import oz.viewer.ui.dlg.OZUtilView;

public class DFInputCompNumber
extends DFInputCompView {
    private static final int DP_BTN_SIZE = 50;
    private static final int DP_IMAGE_SIZE = 18;
    private static final int DP_TEXTVIEW_SIZE = 220;
    private static final int DP_TEXTBOX_MARGIN = 10;
    private static final int DP_SPACE_16 = 16;
    private DFSelectItemView minusButton;
    private DFSelectItemView plusButton;
    private Button resetButton;
    private EditText editText;
    private DFCheckView checkView;
    private String mText;
    private double mUpDownValue;
    private double mMaxValue;
    private double mMinValue;
    private boolean mIsAllowEmpty;
    private DecimalFormat _numberFormat;
    private boolean isInt;
    private View.OnClickListener onClickListener = new DFInputCompNumber$4(this);

    public DFInputCompNumber(Context context, DFInputCompNumber$DFNumberInterface dFInputCompNumber$DFNumberInterface) {
        super(context, dFInputCompNumber$DFNumberInterface);
    }

    private DFInputCompNumber$DFNumberInterface getInterface() {
        return (DFInputCompNumber$DFNumberInterface)this.getDFInterface();
    }

    private void setProperty() {
        this.isInt = this.getInterface().getIncrement() * 10.0 % 10.0 == 0.0;
        this.mText = this.getValidValue();
        this.mUpDownValue = this.getInterface().getIncrement();
        this.mMinValue = this.getInterface().getMinValue();
        this.mMaxValue = this.getInterface().getMaxValue();
        this.mIsAllowEmpty = this.getInterface().isAllowEmpty();
    }

    private void setEditText() {
        this.editText = new EditText(this.getContext());
        if (this.mIsAllowEmpty) {
            this.editText.setText((CharSequence)this.mText);
        } else if ("".equals(this.mText)) {
            this.editText.setText((CharSequence)"0");
        } else {
            this.editText.setText((CharSequence)this.mText);
        }
        this.editText.setGravity(17);
        this.editText.setFocusableInTouchMode(true);
        this.editText.setFocusable(false);
        this.editText.setTextColor(-1);
        this.editText.setInputType(12290);
        this.editText.setBackgroundTintList(ColorStateList.valueOf((int)-1));
        DFInputCompNumber$1 dFInputCompNumber$1 = new DFInputCompNumber$1(this);
        this.editText.addTextChangedListener((TextWatcher)dFInputCompNumber$1);
        this.editText.setOnTouchListener((View.OnTouchListener)new DFInputCompNumber$2(this));
        this.editText.setOnEditorActionListener((TextView.OnEditorActionListener)new DFInputCompNumber$3(this));
    }

    private void setResetButton(ViewGroup viewGroup) {
        this.resetButton = new DFClearButton$Builder(viewGroup).setOnClickListener(this.onClickListener).setSizeDP(22).setLayoutMarginLeftDP(16).create();
        if (this.mIsAllowEmpty) {
            this.resetButton.setVisibility(0);
        } else {
            this.resetButton.setVisibility(4);
        }
    }

    private void setNumberFormat() {
        String[] stringArray;
        int[] nArray = new int[4];
        String[] stringArray2 = OZUtilView.split(this.mText, ".");
        if (stringArray2.length > 1) {
            nArray[0] = stringArray2[1].length();
        }
        if ((stringArray = OZUtilView.split(Double.toString(this.mUpDownValue), ".")).length > 1) {
            nArray[1] = stringArray[1].length();
        }
        String[] stringArray3 = OZUtilView.split(Double.toString(this.mMaxValue), ".");
        if (stringArray.length > 1) {
            nArray[2] = stringArray3[1].length();
        }
        String[] stringArray4 = OZUtilView.split(Double.toString(this.mMinValue), ".");
        if (stringArray.length > 1) {
            nArray[3] = stringArray4[1].length();
        }
        Arrays.sort(nArray);
        int n = nArray[3];
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("0.");
        for (int j = 0; j < n; ++j) {
            stringBuffer.append("#");
        }
        this._numberFormat = new DecimalFormat(stringBuffer.toString());
    }

    private void plusMinusAction(boolean bl) {
        double d2;
        this.adjustText();
        this.mText = this.getValidValue();
        if (this.mIsAllowEmpty && "".equals(this.mText)) {
            this.mText = "" + this.mMinValue;
        }
        if (this.mText.isEmpty() && this.getValue() != null) {
            this.mText = this.getValidValue();
        }
        if (this.mMaxValue < (d2 = Double.parseDouble(this.mText))) {
            d2 = this.mMaxValue;
        } else if (this.mMinValue > d2) {
            d2 = this.mMinValue;
        }
        double d3 = this.checkMaxMinValue(d2 + (bl ? this.mUpDownValue : -this.mUpDownValue));
        this.mText = this._numberFormat.format(d3);
        this.editText.setText((CharSequence)this.mText);
        this.editText.setSelection(this.editText.getText().length());
    }

    private void resetBtnClicked(View view) {
        this.editText.setText((CharSequence)"");
        this.minusButton.setEnabled(true);
        view.setClickable(false);
    }

    private double checkMaxMinValue(double d2) {
        if (this.mMaxValue <= d2) {
            if (this.plusButton != null) {
                this.plusButton.setEnabled(false);
            }
            d2 = this.mMaxValue;
        } else if (this.plusButton != null) {
            this.plusButton.setEnabled(true);
        }
        if (this.mMinValue >= d2) {
            if (this.minusButton != null) {
                this.minusButton.setEnabled(false);
            }
            d2 = this.mMinValue;
        } else if (this.minusButton != null) {
            this.minusButton.setEnabled(true);
        }
        return d2;
    }

    private void adjustText() {
        String string = this.editText.getText().toString();
        if (!this.mIsAllowEmpty && string.isEmpty() || string.equals(".") || string.equals("-")) {
            String string2 = string = this.getValue() != null ? this.getValue().toString() : "";
        }
        if (string.isEmpty()) {
            this.setValue(string);
            return;
        }
        if (Double.parseDouble(string) > this.mMaxValue) {
            if (this.mMaxValue % 1.0 > 0.0) {
                this.setValue(Double.toString(this.mMaxValue));
            } else {
                this.setValue(Integer.toString((int)this.mMaxValue));
            }
        } else if (Double.parseDouble(string) < this.mMinValue) {
            if (this.mMinValue % 1.0 < 0.0) {
                this.setValue(Double.toString(this.mMinValue));
            } else {
                this.setValue(Integer.toString((int)this.mMinValue));
            }
        } else if (Double.parseDouble(string) % 1.0 > 0.0 || Double.parseDouble(string) % 1.0 < 0.0) {
            String string3 = string;
            string3 = string3.replaceAll("-", "");
            if ((string3 = string3.replaceAll("^0{2,}", "")).startsWith(".")) {
                string3 = "0".concat(string3);
            }
            if (string.startsWith("-")) {
                string3 = "-".concat(string3);
            }
            while (string3.endsWith("0")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            this.setValue(string3);
        } else {
            this.setValue(Integer.toString((int)Double.parseDouble(string)));
        }
    }

    protected void create(int n, int n2) {
        this.setProperty();
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setOrientation(1);
        LinearLayout linearLayout2 = new LinearLayout(this.getContext());
        linearLayout2.setOrientation(0);
        linearLayout2.setGravity(16);
        int n3 = DFUtils.toDP(this.getContext(), 18.0f);
        this.minusButton = new DFSelectItemView(this.getContext(), DFUtils.getImageDrawable(this.getContext(), 21));
        this.minusButton.setImageViewSize(n3, -2);
        this.minusButton.setInnerLayoutGravity(17);
        this.minusButton.setOnClickListener(this.onClickListener);
        this.minusButton.setOnTouchListener(this.DFOnTouchListener);
        this.minusButton.setOnlyUseImageButton(false);
        this.plusButton = new DFSelectItemView(this.getContext(), DFUtils.getImageDrawable(this.getContext(), 22));
        this.plusButton.setImageViewSize(n3);
        this.plusButton.setInnerLayoutGravity(17);
        this.plusButton.setOnClickListener(this.onClickListener);
        this.plusButton.setOnTouchListener(this.DFOnTouchListener);
        this.plusButton.setOnlyUseImageButton(false);
        this.setEditText();
        this.setResetButton((ViewGroup)linearLayout2);
        this.setNumberFormat();
        int n4 = DFUtils.toDP(this.getContext(), 50.0f);
        int n5 = DFUtils.toDP(this.getContext(), 10.0f);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        layoutParams.setMargins(n5, 0, n5, 0);
        this.checkView = new DFCheckView(this.getContext());
        linearLayout2.addView((View)this.checkView);
        linearLayout2.addView((View)this.minusButton, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(n4, n4));
        linearLayout2.addView((View)this.editText, (ViewGroup.LayoutParams)layoutParams);
        linearLayout2.addView((View)this.plusButton, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(n4, n4));
        linearLayout2.addView((View)this.resetButton);
        linearLayout.addView((View)linearLayout2);
        linearLayout.addView(this.createConfirmBtn((ViewGroup)linearLayout));
        this.addView((View)linearLayout);
    }

    protected void updateSizeChanged(int n, int n2) {
        int n3 = DFUtils.toDP(this.getContext(), 20.0f);
        this.editText.measure(0, 0);
        this.minusButton.measure(0, 0);
        this.plusButton.measure(0, 0);
        this.resetButton.measure(0, 0);
        int n4 = this.minusButton.getMeasuredWidth();
        int n5 = this.plusButton.getMeasuredWidth();
        int n6 = this.resetButton.getMeasuredWidth();
        int n7 = this.getInterface().getManager().getDialogWidth() - n3 * 2;
        int n8 = n4 + n5 + n6;
        int n9 = n7 - n8;
        int n10 = DFUtils.pxToDp(this.getContext(), n9);
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.editText.getLayoutParams();
        n9 = n7 - n8;
        n10 = DFUtils.pxToDp(this.getContext(), n9);
        if (n10 > 300) {
            n10 = 300;
        }
        layoutParams.width = n10;
        this.editText.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    protected void updateInternal(boolean bl) {
        if (this.getValue() != null) {
            if (bl) {
                this.checkView.requestPlay();
            }
            this.editText.setText((CharSequence)this.getValidValue());
        }
    }

    private String getValidValue() {
        String string = "[0-9.]+";
        String string2 = this.isInt ? Integer.toString((int)this.getInterface().getMinValue()) : Double.toString(this.getInterface().getMinValue());
        String string3 = this.getValue().toString().matches(string) ? this.getValue().toString() : string2;
        return string3;
    }

    public void callOnValueChanged() {
        if (this.editText != null) {
            this.adjustText();
        }
        super.callOnValueChanged();
    }

    protected void disposeInternal(boolean bl) {
        super.disposeInternal(bl);
        DFUtils.tryCloseEditTextKeyboard(this.editText);
    }

    static /* synthetic */ double access$000(DFInputCompNumber dFInputCompNumber) {
        return dFInputCompNumber.mMaxValue;
    }

    static /* synthetic */ String access$102(DFInputCompNumber dFInputCompNumber, String string) {
        dFInputCompNumber.mText = string;
        return dFInputCompNumber.mText;
    }

    static /* synthetic */ boolean access$200(DFInputCompNumber dFInputCompNumber) {
        return dFInputCompNumber.isInt;
    }

    static /* synthetic */ String access$100(DFInputCompNumber dFInputCompNumber) {
        return dFInputCompNumber.mText;
    }

    static /* synthetic */ EditText access$300(DFInputCompNumber dFInputCompNumber) {
        return dFInputCompNumber.editText;
    }

    static /* synthetic */ double access$400(DFInputCompNumber dFInputCompNumber) {
        return dFInputCompNumber.mMinValue;
    }

    static /* synthetic */ boolean access$500(DFInputCompNumber dFInputCompNumber) {
        return dFInputCompNumber.mIsAllowEmpty;
    }

    static /* synthetic */ Button access$600(DFInputCompNumber dFInputCompNumber) {
        return dFInputCompNumber.resetButton;
    }

    static /* synthetic */ DFSelectItemView access$700(DFInputCompNumber dFInputCompNumber) {
        return dFInputCompNumber.minusButton;
    }

    static /* synthetic */ void access$800(DFInputCompNumber dFInputCompNumber, boolean bl) {
        dFInputCompNumber.plusMinusAction(bl);
    }

    static /* synthetic */ DFSelectItemView access$900(DFInputCompNumber dFInputCompNumber) {
        return dFInputCompNumber.plusButton;
    }

    static /* synthetic */ void access$1000(DFInputCompNumber dFInputCompNumber, View view) {
        dFInputCompNumber.resetBtnClicked(view);
    }
}

