/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.main.overlay;

import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import java.util.Hashtable;
import java.util.Map;
import oz.viewer.ui.main.overlay.ANavigatorButtonInfo;
import oz.viewer.ui.main.overlay.ANavigatorManager$1;
import oz.viewer.ui.main.overlay.AOverlayUtil;
import oz.viewer.ui.main.overlay.AutoHideAbleOZOverlayView;
import oz.viewer.ui.main.overlay.OverlayLayout;

public class ANavigatorManager
extends AutoHideAbleOZOverlayView {
    private LinearLayout mView;
    private Map mButtonsInfo;

    public ANavigatorManager(OverlayLayout overlayLayout) {
        super(overlayLayout, 3);
        this.initButtonInfo();
        this.initView();
        this.addButtons();
        this.setEnable(false);
    }

    private void addButtons() {
        this.addButton(14);
        this.addButton(15);
        this.addButton(48);
        this.addButton(49);
        this.addButton(16);
        this.addButton(17);
    }

    private void addButton(int n) {
        this.mView.addView(((ANavigatorButtonInfo)this.mButtonsInfo.get(n)).createButton(this.getContext()));
    }

    private void initButtonInfo() {
        this.mButtonsInfo = new Hashtable();
        this.putButtonInfo(14, 59152);
        this.putButtonInfo(15, 59151);
        this.putButtonInfo(48, 37);
        this.putButtonInfo(49, 36);
        this.putButtonInfo(16, 59153);
        this.putButtonInfo(17, 59154);
    }

    private void initView() {
        this.mView = new LinearLayout(this.getContext());
        this.mView.setOrientation(0);
        this.mView.setPadding(AOverlayUtil.DpToPx(30), 0, AOverlayUtil.DpToPx(30), 0);
        ShapeDrawable shapeDrawable = AOverlayUtil.getRoundRectDrawable(AOverlayUtil.DpToPx(30));
        shapeDrawable.getPaint().setAntiAlias(true);
        shapeDrawable.getPaint().setColor(Color.argb((int)191, (int)0, (int)0, (int)0));
        shapeDrawable.getPaint().setStyle(Paint.Style.FILL);
        this.mView.setBackgroundDrawable((Drawable)shapeDrawable);
        this.mView.setOnTouchListener((View.OnTouchListener)new ANavigatorManager$1(this));
        this.mView.setVisibility(4);
    }

    private void putButtonInfo(int n, int n2) {
        this.mButtonsInfo.put(n, new ANavigatorButtonInfo(this, n, n2));
    }

    public void setButtonEnable(int n, boolean bl) {
        ANavigatorButtonInfo aNavigatorButtonInfo = (ANavigatorButtonInfo)this.mButtonsInfo.get(n);
        if (aNavigatorButtonInfo != null && aNavigatorButtonInfo.isEnabled() != bl) {
            aNavigatorButtonInfo.setEnabled(bl);
            this.requestNeedUpdateView();
        }
    }

    protected View getView() {
        return this.mView;
    }

    protected void addToOverlayView(OverlayLayout overlayLayout, View view) {
        ViewGroup viewGroup = (ViewGroup)overlayLayout.findLayout(22000);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2, 81);
        layoutParams.bottomMargin = AOverlayUtil.DpToPx(15);
        viewGroup.addView(view, (ViewGroup.LayoutParams)layoutParams);
    }

    public boolean isAutoHideEnable() {
        return this.getOZParent().getIconToolbar().isAutoHideEnable();
    }
}

