package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

import java.util.ArrayList;

import jp.agentec.abook.abv.bl.acms.client.json.AcmsCommonJSON;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;
import jp.agentec.abook.abv.bl.dto.WorkerGroupDto;

/**
 * Created by leej on 2018/08/27.
 */

public class WorkerGroupJSON extends AcmsCommonJSON {
    private static final String GroupList = "groupList";
    private static final String GroupId = "groupId";
    private static final String GroupName = "groupName";

    public ArrayList<WorkerGroupDto> workerGroupList;

    public WorkerGroupJSON(String jsonString) throws AcmsException {
        super(jsonString);
    }

    @Override
    protected void parse(JSONObject json) throws JSONValidationException {
        workerGroupList = new ArrayList<WorkerGroupDto>();
        if (json.has(GroupList)) {
            JSONArray workerGroupListJson = json.getJSONArray(GroupList);
            for(int i = 0; i < workerGroupListJson.length(); i++) {
                JSONObject workerGroupJson = workerGroupListJson.getJSONObject(i);
                WorkerGroupDto dto = new WorkerGroupDto();
                dto.groupId = getInt(workerGroupJson, GroupId);
                dto.groupName = getString(workerGroupJson, GroupName);
                workerGroupList.add(dto);
            }
        }
    }
}
