package jp.agentec.abook.abv.bl.acms.client.parameters;

import jp.agentec.adf.net.http.HttpParameterObject;

/**
 * ACMSのAPIに渡す共通的なパラメータを格納します。ACMSのAPIのパラメータ用クラスを作成するときはこのクラスを継承してください。<br>
 * ただし、このクラスはログイン状態の確認用として使われる {@link ArchiveDetailRequestParameters#sid} を持っているため、ログイン用のパラメータ {@link MobileLoginParameters} は、このクラスを継承する必要はありません。
 * @author lee-mk
 * @version 1.0.0
 */
public class ArchiveDetailRequestParameters extends HttpParameterObject {
	/**
	 * セッションID
	 * @since 1.0.0
	 */
	private String sid;
	private String cmd;
	private Integer archiveId;
	private Integer collaborationDetailId;

	/**
	 * {@link ArchiveDetailRequestParameters} のインスタンスを初期化します。
	 * @param sid ログインした時のセッションIDです。
	 * @param cmd Apiリクエストに必要なコマンド（ABOOK COMM専用）。
	 * @since 1.0.0
	 */
	public ArchiveDetailRequestParameters(String sid, String cmd, Integer archiveId, Integer collaborationDetailId) {
		this.sid = sid;
		this.cmd = cmd;
		this.archiveId = archiveId;
		this.collaborationDetailId = collaborationDetailId;
	}

	/**
	 * セッションIDを返します。
	 * @return ログインした時のセッションIDです。
	 * @since 1.0.0
	 */
	public String getSid() {
		return sid;
	}

	/**
	 * コマンドを返します。
	 * @return ログインした時のセッションIDです。
	 * @since 1.0.0
	 */
	public String getCmd() {
		return cmd;
	}

	/**
	 * archiveIdを返します。
	 * @return 詳細取得対象のIDです。
	 * @since 1.0.0
	 */
	public Integer getArchiveId() {
		return archiveId;
	}

	/**
	 * collaborationDetailIdを返します。
	 * @return collaborationDetailId
	 * @since 1.0.0
	 */
	public Integer getCollaborationDetailId() {
		return collaborationDetailId;
	}
}
